#!/bin/sh
################################################################################
#
# File: buildsvndemo.sh
# Name: eZ publish (v2) svn trunk build onlline demo script
# Description: 
# This script will when run, 
# - checkout or export the current eZ publish (v2.3+) svn trunk source codde.
# - prepare the trunk for non-developers
# - remove the existing database and code
# - install and configure the database and code for the online demo
#
# Author: Graham Brookins : Brookins Consulting : <info@brookinsconsulting.com>
# Licence: GNU GPL v2 (or greater)
# Arguments / Usage:
# - #1 (Optional) : VERBOSE ( 0 , 1 ). usage: ./buildsvn.sh 0;
#
# Requirements:
# - GNU bash, version 2.05b.0(1)-release-(i386-redhat-linux-gnu)
# - MySQL (v4.0)
# - Subverion (svn v1.0)
#
# Created: 01/16/2005 @ 03:09am
# Updated: 01/17/2005 @ 03:00am
# Version: 1.2.4
#
# History:
# - Created (01/16/2005) : Inital Script Created
# - Added (01/16/2005) : Support for Dependant Script Arguments
# - Added (01/17/2005) : Code Documentaion, Refinements, Cleaner Variable Names
# - Added (01/17/2005) : Verbose Argument, Verbose Mode, Cleaner Variable Names, Locations, Comments
#
################################################################################

################################################################################
# Direcotry Location where the online demo is to be installed and configured for hosting

DEMO_WEBDOCS_DIRECTORY="/home/web/ezcommunity/demo.ezpublish23";

# Database Variables (Change)
ONLINE_DEMO_DB_NAME="ezpublish23_svn_trunk_demo";
ONLINE_DEMO_DB_USER="demo23svn";
ONLINE_DEMO_DB_PASS="demo23svn";


################################################################################
# Arguments for sub script ( buildsvn.sh ) build functions

EZBUILD_GET_SVN=1;
EZBUILD_PREPARE_TRUNK=1;
EZBUILD_RENAME_TRUNK=1;
EZBUILD_PACKAGE_BUILD=1;
EZBUILD_REMOVE_BUILD_CODE=0;

# Remove buildsvndemo.sh build files at completion
# Different var than EZBUILD_REMOVE_BUILD_CODE overide for buildsvn.sh 
REMOVE_BUILD_DIRECTORY=1;

# Reload Demo Database
DB_RELOAD=1;


################################################################################
# Export shell variables arguments for secondary script ( buildsvn.sh )

export EZBUILD_REMOVE_BUILD_CODE;
export EZBUILD_GET_SVN;
export EZBUILD_PREPARE_TRUNK;
export EZBUILD_RENAME_TRUNK;
export EZBUILD_PACKAGE_BUILD;


################################################################################
# Argument #1 : 0 = silent or 1 = verbose, default 0:  (usage: ./buildsvndemo.sh 0 )

# Clear Terminal Screan
clear;

if [ $1 ]; then
   # Assign method based on argument
   if [ $1 == '0' ]; then
      VERBOSE=0;
   else
      VERBOSE=1;
   fi

   if [ $VERBOSE -eq 1 ]; then
      echo;
      echo "Optional Variable Passed (VERBOSE): $VERBOSE";
   fi
else
   # Default VERBOSITY IS 0, Silent
   VERBOSE=0;
fi

################################################################################
# Executable Scripts & Programs

CWD=`pwd`;

# BUILD_SVN_CMD='/home/build/buildsvn.sh 0 0';

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   BUILD_SVN_CMD="$CWD/buildsvn.sh 1 0";
else 
   BUILD_SVN_CMD="$CWD/buildsvn.sh 0 0";
fi

MYSQLADMIN="/usr/bin/mysqladmin";
MYSQL="/usr/bin/mysql";


################################################################################
# Print Start Date for cron log file records

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   DEMO_START_DATE=`date`;
   echo;
   echo "Started buildsvndemo.sh at: $DEMO_START_DATE";
fi


################################################################################
# Get existing svn trunk source code (via the existing build script)

echo;
echo "[ $BUILD_SVN_CMD ] Getting svn trunk source code...";
source $BUILD_SVN_CMD;


################################################################################
# [ buildsvn.sh ] Package Build Variables (Above)

if [ $EZBUILD_ORIGINAL_WORKING_DIRECTORY ]; then
   ORIGINAL_WORKING_DIRECTORY=$EZBUILD_ORIGINAL_WORKING_DIRECTORY;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Passed: ORIGINAL_WORKING_DIRECTORY = $ORIGINAL_WORKING_DIRECTORY";
   fi
   unset EZBUILD_ORIGINAL_WORKING_DIRECTORY;
else
   ORIGINAL_WORKING_DIRECTORY=`pwd`;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: ORIGINAL_WORKING_DIRECTORY = $ORIGINAL_WORKING_DIRECTORY";
   fi
fi


if [ $EZBUILD_DIR ]; then
   BUILD_DIR=$EZBUILD_DIR;

   # Verbose or Silent Switch 
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Passed: BUILD_DIR = $BUILD_DIR";
   fi
   unset EZBUILD_DIR;
else
   BUILD_DIR="UNKNOWN";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: BUILD_DIR = $BUILD_DIR";
   fi
fi

if [ $EZBUILD_PACKAGE_NAME ]; then
   PACKAGE_NAME=$EZBUILD_PACKAGE_NAME;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Passed: PACKAGE_NAME = $PACKAGE_NAME";
   fi
   unset EZBUILD_PACKAGE_NAME;
else
   PACKAGE_NAME="UNKNOWN";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: PACKAGE_NAME = $PACKAGE_NAME";
   fi
fi


################################################################################
# Build package dirs (from buildsvn.sh)

PACKAGE_BUILD_PATH=$BUILD_DIR;
PACKAGE_BUILD_PATH=$PACKAGE_BUILD_PATH/;
PACKAGE_BUILD_PATH=$PACKAGE_BUILD_PATH$PACKAGE_NAME;

# Verbose or Silent Switch
#if [ $VERBOSE -eq 1 ]; then
   # echo;
   # echo the build directories $PACKAGE_BUILD_PATH $BUILD_DIR $PACKAGE_NAME
   # echo the build directories $BUILD_DIR $PACKAGE_NAME $PACKAGE_BUILD_PATH $DEMO_WEBDOCS_DIRECTORY;
   # echo " exiting in the middle of buildsvndemo.sh ";
   # exit;
#fi


################################################################################
# Build Path & SQL Files

ONLINE_DEMO_BUILD_PATH="$DEMO_WEBDOCS_DIRECTORY/";
ONLINE_DEMO_BUILD_PATH="$ONLINE_DEMO_BUILD_PATH$PACKAGE_NAME";

ONLINE_DEMO_SQL_STRUCTURE="$ONLINE_DEMO_BUILD_PATH/bin/sql/publish_mysql.sql";
ONLINE_DEMO_SQL_DATA="$ONLINE_DEMO_BUILD_PATH/bin/sql/data_mysql.sql";

# /home/build/ezpublish23svn/trunk/bin/sql/data_mysql.sql
# /home/build/ezpublish23svn/trunk/bin/sql/publish_mysql.sql



################################################################################
# Remove the existing symbolic link and source code for the online demo

echo;
echo "Removing the existing symbolic link and source code for the online demo";

PREVIOUS_PACKAGE="/ezpublish2-3-0_*";

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   echo "rm -f $DEMO_WEBDOCS_DIRECTORY/html";
   # echo "rm -rf $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME";
   echo "rm -rf $DEMO_WEBDOCS_DIRECTORY$PREVIOUS_PACKAGE";
fi

rm -f $DEMO_WEBDOCS_DIRECTORY/html;
# rm -rf $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME;
rm -rf $DEMO_WEBDOCS_DIRECTORY$PREVIOUS_PACKAGE;


################################################################################
# Install the source code for the online demo

echo;
echo "Intalling svn trunk source code for online demo";

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   echo "cp -a $PACKAGE_BUILD_PATH $DEMO_WEBDOCS_DIRECTORY";
fi

cp -a $PACKAGE_BUILD_PATH $DEMO_WEBDOCS_DIRECTORY ;



################################################################################
# Install the online demo site.ini

if [ -f $ORIGINAL_WORKING_DIRECTORY/examples/site.ini ]; then
if [ -d $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/bin/ini/override/ ]; then
    echo;
    echo "Install the online demo site.ini";

    # Verbose or Silent Switch
    if [ $VERBOSE -eq 1 ]; then
        echo "$ORIGINAL_WORKING_DIRECTORY/examples/site.ini $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/bin/ini/override/";
        # echo "cp -a $DEMO_WEBDOCS_DIRECTORY/build/site.ini $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/bin/ini/override/ ";
    fi

    # cp -a $DEMO_WEBDOCS_DIRECTORY/build/site.ini $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/bin/ini/override/;
    cp -a $ORIGINAL_WORKING_DIRECTORY/examples/site.ini $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/bin/ini/override/;
fi
fi


################################################################################
# Install the online demo .htaccess file

if [ -f $ORIGINAL_WORKING_DIRECTORY/examples/.htaccess ]; then
if [ -d $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/bin/ini/override/ ]; then
   echo;
   echo "Install the online demo .htaccess file";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
       echo "cp -a $ORIGINAL_WORKING_DIRECTORY/examples/.htaccess $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/";
   fi

   # cp -a $ORIGINAL_WORKING_DIRECTORY/build/.htaccess $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/;
   cp -a $ORIGINAL_WORKING_DIRECTORY/examples/.htaccess $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME/;
fi
fi


################################################################################
# Create web server symbolic link to demo build

if [ -d $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME ]; then
    echo;
    echo "Creating web server symbolic link to demo build";

    # Verbose or Silent Switch
    if [ $VERBOSE -eq 1 ]; then
        echo "ln -s $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME $DEMO_WEBDOCS_DIRECTORY/html";
    fi

    ln -s $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME $DEMO_WEBDOCS_DIRECTORY/html;
fi


################################################################################
# Drop the existing online demo database

if [ $DB_RELOAD ]; then
   echo;
   echo "Droping the existing online demo database";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
       echo "$MYSQLADMIN -f -u $ONLINE_DEMO_DB_USER DROP $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS ";
   fi
   
   $MYSQLADMIN -f -u $ONLINE_DEMO_DB_USER DROP $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS ;


################################################################################
# Create the online demo database

   echo;
   echo "Creating the online demo database";
   
   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
       echo "$MYSQLADMIN -f -u $ONLINE_DEMO_DB_USER CREATE $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS ";
   fi
   
   $MYSQLADMIN -f -u $ONLINE_DEMO_DB_USER CREATE $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS ;


################################################################################
# Load the database sql structure

   echo;
   echo "Loading the database structure and data sql";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
       echo "$MYSQL -u $ONLINE_DEMO_DB_USER $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS < $ONLINE_DEMO_SQL_STRUCTURE";
       echo "$MYSQL -u $ONLINE_DEMO_DB_USER $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS < $ONLINE_DEMO_SQL_DATA;";
   fi

   $MYSQL -u $ONLINE_DEMO_DB_USER $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS < $ONLINE_DEMO_SQL_STRUCTURE ;
   $MYSQL -u $ONLINE_DEMO_DB_USER $ONLINE_DEMO_DB_NAME --password=$ONLINE_DEMO_DB_PASS < $ONLINE_DEMO_SQL_DATA ;
fi 


################################################################################
# Configure Online SVN Trunk Demo File Permissions

ICWD=`pwd`;
echo;
echo "Setting File & Directory Permissions";

# Run eZ publish modfix.sh or secure_modfix.sh
if [ $UID == 0 ]; then
    cd $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME;
    ./bin/shell/secure_modfix.sh apache apache;
    cd $ICWD;
    # echo $ICWD;
else 
    # echo $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME;
    cd $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME;
    ./bin/shell/modfix.sh;
    cd $ICWD;
    # echo $ICWD;
fi


################################################################################
# (As Root) Change owner ship of core demo site files to web server user and group.

# I'm not going to use this option by default because the permissions 777 are inharently insecure. 
# Others may want or need this option.

# echo "chmod 777 $DEMO_WEBDOCS_DIRECTORY";
# chmod 777 $DEMO_WEBDOCS_DIRECTORY;


################################################################################
# Unpack eZ publish data packages

echo;
echo "Unpacking data.tar.gz and eztrade.tar.gz data archives (required)";
cd $DEMO_WEBDOCS_DIRECTORY/$PACKAGE_NAME;
tar -zvxf bin/data/data.tar.gz;
echo;
tar -zvxf bin/data/checkout.tgz;


################################################################################
# Enable Public Demo (Admin Password Change Prevention) Site.ini Flag (Hidden Var?)
# Did this feature get commited and documented?


################################################################################
# Remove build source code (switch) temp files created from the build

if [ $REMOVE_BUILD_DIRECTORY -eq 1 ]; then
   echo;
   echo "Removing Build Files";

   PREVIOUS_BUILD_DIR="/ezpublish2-3-0_*";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "rm -rf $BUILD_DIR/$ARCHIVE_NAME";
      echo "rm -rf $BUILD_DIR/$PACKAGE_NAME";

      echo "rm -rf $BUILD_DIR$PREVIOUS_PACKAGE";
      echo "rm -rf $BUILD_DIR";
   fi

   rm -rf $BUILD_DIR/$ARCHIVE_NAME;
   rm -rf $BUILD_DIR/$PACKAGE_NAME;
   rm -rf $BUILD_DIR$PREVIOUS_PACKAGE;
   rm -rf $BUILD_DIR;
fi


################################################################################
# Print Start & End Date for cron log file records

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   DEMO_END_DATE=`date`;
   echo;
   echo "Started buildsvndemo.sh at: $DEMO_START_DATE";
   echo "Ended   buildsvndemo.sh at: $DEMO_END_DATE";
fi


################################################################################
# Completed Build and Installation of eZ publish 2.3.0 SVN Trunk

cd $ORIGINAL_WORKING_DIRECTORY;

echo;
echo "Completed Build and Installation of eZ publish 2.3.0 SVN Trunk";
echo;
echo "Happy Hacking!";
echo;

################################################################################
# END OF LINE
################################################################################

