#!/bin/sh
################################################################################
#
# File: buildsvn.sh
# Name: eZ publish (v2) svn trunk build / package script
# Description: 
# This script will when run, 
# - checkout or export the current eZ publish (v2.3+) svn trunk source codde.
# - prepare the trunk for non-developers
# - package the code
# - copy the package to the web server
#
# Author: Graham Brookins : Brookins Consulting <info@brookinsconsulting.com>
# Licence: GNU GPL v2 (or greater)
# Arguments / Usage:
# - #1 [Required] : VERBOSE ( 0 , 1 ). usage: ./buildsvn.sh 0;
# - #2 (Optional) : SVN_METHOD ( 0 , 1 ). usage: ./buildsvn.sh 0 0;
# - #3 (Not Used) : SVN_REPOSOTRY ( url ). usage: ./buildsvn.sh 0 0;
# - #4 (Not Used) : PACKAGE_DESTINATION_DIR ( path ). usage: ./buildsvn.sh 0 0;
# 
# Requirements:
# - GNU bash, version 2.05b.0(1)-release-(i386-redhat-linux-gnu)
# - MySQL (v4.0)
# - Subverion (svn v1.0)
#
# Created: 01/15/2005 @ 4pm
# Updated: 01/17/2005 @ 04:07am
# Version: 1.2.4
#
# History:
# - Created (01/15/2005) : Inital Script Created
# - Added (01/16/2005) : Support for Parent Script builddemosvn.sh (optional argument variable passing)
# - Added (01/17/2005) : Arguments (optinal) #1 & #2 : VERBOSE SVN_Method
# - Added (01/17/2005) : Usage Statement, Argument Order Switch, Directory Variable Abstraction (cleanup)
#
################################################################################


################################################################################
# Usage Statement : When No Arguments are Passed Print Usage Statement (Optinal/Required)

CMD_ARG_COUNT=$#;

if [ $CMD_ARG_COUNT -lt 1 ]; then
   echo "Usage: $0 [Verbose] (SVN_Method)";
   echo 1>&2 Usage: $0 0;
   echo "Usage: $0 0 0";
   exit 187;
fi
if [ $CMD_ARG_COUNT -gt 2 ]; then
   echo "Usage: $0 [Verbose] (SVN_Method)";
   echo 1>&2 Usage: $0 0;
   echo "Usage: $0 0 0";
   exit 187;
fi

################################################################################
# Argument #1 : 0 = silent or 1 = verbose, default 0:  (usage: ./buildsvn.sh 0 )

# If var is not set then, clear terminal screen
if [ $EZBUILD_REMOVE_BUILD_CODE ]; then
   CHILD_SCRIPT_OF_PARENT=1;
else
   clear;
fi

if [ $1 ]; then
   # Assign method based on argument
   if [ $1 == '0' ]; then
      VERBOSE=0;
   else
      VERBOSE=1;
   fi

   if [ $VERBOSE -eq 1 ]; then
      echo;
      echo "Optional Variable Passed (VERBOSE): $VERBOSE";
   fi
else
   # Default VERBOSITY IS 0, Silent
   VERBOSE=0;
fi


################################################################################
# Print script start stamp for cron log file records

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   START_DATE=`date`;
   echo;
   echo "Started buildsvn.sh at: $START_DATE";
fi


################################################################################
# Argument #2 : 0 = export or 1 = checkout, default 0:  (usage: ./buildsvn.sh 0 0 ) 

if [ $2 ]; then
   # Assign method based on argument
   if [ $2 == '0' ]; then
      METHOD='export';
   else
      METHOD='checkout';
   fi

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo;
      echo "Optional Variable Passed (METHOD): $METHOD";
   fi
else
   # Default method is export
   METHOD='export';

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo;
      echo "SVN (METHOD): $METHOD";
   fi
fi


################################################################################
# Assign variables used in the script

# Current Working Directory
CWD=`pwd`;
ORIGINAL_WORKING_DIRECTORY=`pwd`;

# SVN Repository (Used to obtain the trunk source code)

# Third Argument (Repository URL)
# if [$3]; then
# REPOSITORY=$3;
# else
REPOSITORY='http://pubsvn.ez.no/ezcommunity2/ezcommunity/trunk/';
# fi

# Directory the built package tar.gz file is copied to after successfull completion of script

# Fourth Argument (Package Destination Directory)
# if [$4]; then
# PACKAGE_DESTINATION_DIR=$4;
PACKAGE_DESTINATION_DIR='/home/web/ezcommunity.net/html/download/svn_builds/';
# else
# PACKAGE_DESTINATION_DIR="$CWD";
# fi

BUILD_DIR="$CWD/.ezpublish23svn";

# Package (Unix Friendly) Date Time Stamp 
TIME_STAMP=`date +%F_%H%M%S`;
TIME_STAMP="_$TIME_STAMP";

# Current svn build version (replace with tag name + svn rev, dynamic)
PRODUCT_NAME='ezpublish';
VERSION_TAG='2-3-0';

#SVN_SUBVERSION_TAG='rev280 OR (get from exported file + parse)'; 
PACKAGE_EXT='.tar.gz';
PACKAGE_NAME="$PRODUCT_NAME$VERSION_TAG$TIME_STAMP";
ARCHIVE_NAME="$PACKAGE_NAME$PACKAGE_EXT";

# SVN Program Binary Command
# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
    SVN='/usr/bin/svn --force';
else
    SVN='/usr/bin/svn -q --non-interactive --force';  
fi 


################################################################################
# Evaluate (Optional) Passed Arguments, If not set default status is true
 
if [ $EZBUILD_REMOVE_BUILD_CODE ]; then
   REMOVE_BUILD_CODE=$EZBUILD_REMOVE_BUILD_CODE;
   echo;
   echo "Argument Passed: REMOVE_BUILD_CODE = $REMOVE_BUILD_CODE";
   unset EZBUILD_REMOVE_BUILD_CODE;
else
   REMOVE_BUILD_CODE=1;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: REMOVE_BUILD_CODE = $REMOVE_BUILD_CODE";
   fi
fi


if [ $EZBUILD_PACKAGE_BUILD ]; then
   PACKAGE_BUILD=$EZBUILD_PACKAGE_BUILD;
   echo "Argument Passed: PACKAGE_BUILD = $PACKAGE_BUILD";
   unset EZBUILD_PACKAGE_BUILD;
else
   PACKAGE_BUILD=1;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: PACKAGE_BUILD = $PACKAGE_BUILD";
   fi
fi


if [ $EZBUILD_GET_SVN ]; then
   GET_SVN=$EZBUILD_GET_SVN;
   echo "Argument Passed: GET_SVN = $GET_SVN";
   unset EZBUILD_GET_SVN;
else
   GET_SVN=1;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: GET_SVN = $GET_SVN";
   fi
fi


if [ $EZBUILD_PREPARE_TRUNK ]; then
   PREPARE_TRUNK=$EZBUILD_PREPARE_TRUNK;
   echo "Argument Passed: PREPARE_TRUNK = $PREPARE_TRUNK";
   unset EZBUILD_PREPARE_TRUNK;
else
   PREPARE_TRUNK=1;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: PREPARE_TRUNK = $PREPARE_TRUNK";
   fi
fi


if [ $EZBUILD_RENAME_TRUNK ]; then
   RENAME_TRUNK=$EZBUILD_RENAME_TRUNK;
   echo "Argument Passed: RENAME_TRUNK = $RENAME_TRUNK";
   unset EZBUILD_RENAME_TRUNK;
else
   RENAME_TRUNK=1;

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      echo "Argument Not Passed: RENAME_TRUNK = $RENAME_TRUNK";
   fi
fi


################################################################################
# change directory to ezcommunity build

echo;
if [ -d $BUILD_DIR ]; then
   cd $BUILD_DIR;
else 
   mkdir $BUILD_DIR;
   echo "Creating Build Direcotry: $BUILD_DIR";
   cd $BUILD_DIR;
fi
echo "Changing Directory to build area : $BUILD_DIR";

################################################################################
# checkout / export current eZ publish 2.3 trunk

if [ $GET_SVN -eq 1 ]; then
   echo;
   echo "Getting current $METHOD eZ publish 2 svn trunk source code..."; # $SVN $METHOD $REPOSITORY";
   $SVN $METHOD $REPOSITORY;
fi


################################################################################
# Prepare eZ publish trunk to be usable by people

if [ $PREPARE_TRUNK -eq 1 ]; then
   echo;
   echo "Preparing build's svn trunk source code for packaging...";
   cd trunk ;
   if [ -d publish_dist/ ]; then
       mv publish_dist/* . ;
       mv publish_dist/.cvsignore publish_dist/.htaccess . ;
       rm -rf publish_dist/ ;
   fi
   cd ../ ;
fi


################################################################################
# rename trunk dir to be usable by people

if [ $RENAME_TRUNK -eq 1 ]; then
   mv trunk $PACKAGE_NAME;
else 
   PACKAGE_NAME='trunk';
fi

################################################################################
# package the export of the svn trunk

# pwd;

if [ $PACKAGE_BUILD -eq 1 ]; then
   # echo "$ARCHIVE_NAME $PACKAGE_NAME";
   echo;
   echo "Packaging eZ publish svn trunk";


   if [ -d $PACKAGE_NAME ]; then
      # Verbose or Silent Switch
      if [ $VERBOSE -eq 1 ]; then
         echo "tar -zcf $ARCHIVE_NAME $PACKAGE_NAME";
      fi
   tar -zcf $ARCHIVE_NAME $PACKAGE_NAME;
   fi


   if [ -f $ARCHIVE_NAME ]; then   
   if [ -d $PACKAGE_DESTINATION_DIR ]; then
      # move export of the svn trunk to the web server
      echo;
      echo "Publishing eZ publish svn trunk package";

      # Verbose or Silent Switch
      if [ $VERBOSE -eq 1 ]; then
         echo "$ARCHIVE_NAME $PACKAGE_DESTINATION_DIR";
      fi
   cp -a $ARCHIVE_NAME $PACKAGE_DESTINATION_DIR;
   fi
   fi
fi


################################################################################
# remove the temp files created from the build

if [ $REMOVE_BUILD_CODE -eq 1 ]; then
   echo;
   echo "Removing Build Files";

   # Verbose or Silent Switch
   if [ $VERBOSE -eq 1 ]; then
      pwd;
      echo "rm -rf $PACKAGE_NAME ; rm -rf $ARCHIVE_NAME ";
      echo $BUILD_DIR/.ezpublish*;
   fi
   # Remove Package Archive
   rm -rf $ARCHIVE_NAME ;
   # Remove Build Package 
   rm -rf $PACKAGE_NAME ;
   # Remove all Previous Build Package Directories
   rm -rf $BUILD_DIR/ezpublish*;
   # Remove the build .ezpublish23svn directory
   rm -rf $BUILD_DIR;
fi


################################################################################
# Return to Original Working Directory

#pwd;
echo;
echo "Returning to original working directory: $ORIGINAL_WORKING_DIRECTORY ";
cd $ORIGINAL_WORKING_DIRECTORY;


################################################################################
# Print script completion stamp for cron log file records

# Verbose or Silent Switch
if [ $VERBOSE -eq 1 ]; then
   END_DATE=`date`;
   echo;
   echo "Started buildsvn.sh at: $START_DATE";
   echo "Ended   buildsvn.sh at: $END_DATE";
fi


################################################################################
# Export Variables for ./buildsvndemo.sh dependancies (Can you export to parent shell?)

EZBUILD_DIR=$BUILD_DIR;
EZBUILD_PACKAGE_NAME=$PACKAGE_NAME;
EZBUILD_ORIGINAL_WORKING_DIRECTORY=$ORIGINAL_WORKING_DIRECTORY;

export EZBUILD_DIR;
export EZBUILD_PACKAGE_NAME;
export EZBUILD_ORIGINAL_WORKING_DIRECTORY


################################################################################
# END OF LINE
################################################################################
