<?php
function etc($array,$etc) {
	for ($i=$etc;$i<=count($array)-1;$i++) {
		$return .= $array[$i]." ";
	}
	return substr($return,0,-1);
}

function gettok($str,$tok,$splitter=" ") {
	global $_gettok_temp_str,$_gettok_temp_tok;
	if ($_gettok_temp_str != $str || $_gettok_temp_splitter != $splitter || !$_gettok_temp_array) {
		$_gettok_temp_splitter=$splitter;
		$_gettok_temp_str=$str;
		$_gettok_temp_array=split($_gettok_temp_splitter,$_gettok_temp_str);
	}
	return $_gettok_temp_array[$tok];
}

function duration ($elapsed,$short=0) {
	$days = floor($elapsed / 86400);
	$elapsed = $elapsed - ($days*86400);
	$hours = floor($elapsed / 3600);
	$elapsed = $elapsed - ($hours*3600);
	$minutes = floor($elapsed / 60);
	$elapsed = $elapsed - ($minutes*60);
	if ($days > 0) { 
		$return .= $days;
		$return .= ($short) ? "d" : " days, ";
	}
	if ($hours > 0) {
		$return .= $hours;
		$return .= ($short) ? "h" : " hours, ";
	}
	if ($minutes > 0) {
		$return .= $minutes;
		$return .= ($short) ? "m" : " minutes, ";
	}
	if ($elapsed >= 0) {
		$return .= $elapsed;
		$return .= ($short) ? "s" : " seconds, ";
	}
	return ($short) ? $return : substr($return,0,-2);
}

function parsemask ($hostmask) {
	$foo=split("!",$hostmask);
	$nick=$foo[0];
	list($ident,$host)=split("@",$foo[1]);
	return array($nick,$ident,$host);
}

function set_titlebar($text) {
	echo chr(27)."]2;$text".chr(7);
}

function ctext ($text, $color="normal") {
	$_colors = array(
		"red" => "[0;31m", 
		"light_red" => "[1;31m",
		"green" => "[0;32m", 
		"light_green" => "[1;32m", 
		"yellow" => "[0;33m", 
		"light_yellow" => "[1;33m",
		"blue" => "[0;34m", 
		"light_blue" => "[1;34m", 
		"magenta" => "[0;35m",
		"light_magenta" => "[1;35m",
		"cyan" => "[0;36m", 
		"light_cyan" => "[1;36m", 
		"white" => "[1;37m", 
		"normal" => "[0m", 
		"black" => "[0;30m",
		"gray" => "[1;30m",
		"brown" => "[0;33m", 
		"bold" => "[1m", 
		"underline" => "[4m", 
		"reverse" => "[7m", 
	);
	
	$out = $_colors["$color"]; 
	if ($out == "") { 
		$out = "[0m";
	} 
	return chr(27)."$out$text".chr(27)."[0m";#.chr(27); 
}

function errorHandler($errno,$errmsg,$filename,$linenum,$vars) {
	global $bot;
	$errortype=array(
     	E_ERROR => "Error",
		E_WARNING => "Warning",
		E_PARSE => "Parse Error",
		E_NOTICE => "Notice",
		E_CORE_ERROR => "Core Error",
		E_CORE_WARNING => "Core Warning",
		E_COMPILE_ERROR => "Compile Error",
		E_COMPILE_WARNING => "Compile Warning",
		E_USER_ERROR => "User Error",
		E_USER_WARNING => "User Warning",
		E_USER_NOTICE => "User Notice",
		E_STRICT => "Runtime Notice"
	);
	
	if ($errno != E_NOTICE && $errno != E_STRICT) {
		$bot->log($bot->themeize("error",array($errortype[$errno],strip_tags($errmsg),$filename,$linenum)));
	}
}

function signalHandler($signo) {
	global $bot;
	$bot->debug("Caught signal: $signo");
	if ($signo==SIGHUP) {
		$bot->log("SIGHUP received, rehashing..");
		$bot->rehash();
	}
	elseif ($signo==SIGTERM) {
		$bot->log("Received termination signal, exiting..");
		$bot->raw("QUIT :sigterm received",false);
		exit(0);
	}
}

// this function returns all data from $URL page as an array
function HTTPGet($url,$timeout=5,$returnHead=false) {
	$parse=parse_url($url);
	$host=$parse["host"];
	$port=($parse["port"]) ? $parse["port"] : 80;
	$uri=($parse["path"]) ? $parse["path"] : "/";
	$uri.=($parse["query"]) ? "?{$parse["query"]}" : "";
	$fp=fsockopen($host,$port,$errno,$errstr,$timeout);
	if (!$fp) {
		return 0;
	}
	else {
		stream_set_timeout($fp,$timeout);
		fputs($fp,"GET $uri HTTP/1.1\r\n");
		fputs($fp,"Host: $host\r\n");
		fputs($fp,"User-Agent: Mozilla/5.0 (compatible; IQ)\r\n");
		fputs($fp,"Connection: close\r\n");
		fputs($fp,"\r\n");
		$output=array();
		$fullOut=array();
		$flag=0;
		while (true) {
			$buffer=fgets($fp);
			$fullOut[]=$buffer;
			if (!trim($buffer)) {
				$foo=stream_get_meta_data($fp);
				if ($foo["timed_out"]) {
					if (count($output)) { return $output; } else { return 0; }
				}
				elseif ($foo["eof"]) {
					return $output;
				}
			}
			if (trim($buffer)=="") {
				if ($returnHead) {
					array_pop($fullOut);
					return $fullOut;
				}
				$flag=1;
			}
			if ($flag && trim($buffer)) { $output[]=$buffer; }
		}
	}
}

function HTTPHead($url,$timeout=5) {
	return HTTPGet($url,$timeout,true);
}

// parseLine(): for command line parsing.
// $args is an array of the arguments as part of $argv, originally.
function parseLine($args) {
	$output=array();
	for ($i=0;$i<count($args);$i++) {
		if (substr($args[$i],0,1)=="-") {
			$lastswitch=substr($args[$i],1);
			$output[$lastswitch]="";
		}
		elseif ($lastswitch) {
			$output[$lastswitch].=" ".$args[$i];
			$output[$lastswitch]=trim($output[$lastswitch]);
		}
	}
	return $output;
}
?>
