<?php
/***************************************************************************** 
 * This is the configuration file for IQ 0.9.x                               *
 * If you are upgrading from an earlier version, it is HIGHLY recommended    * 
 * that you configure your bot from scratch, rather than use a configuration *
 * file from an older version. Newer versions may contain more configuration *
 * options required by the core, and variable names may change from version  *
 * to version.                                                               *  
 *                                                                           * 
 * Read and configure the options below. PAY ATTENTION TO THE COMMENTS.      * 
 *****************************************************************************/

// Bot's IRC nickname
$this->config["nickname"] = "ezlog";

// Try this nickname if primary nick is in use
$this->config["altnick"] = "ezpublishlog";

// "Real name" field for the bot. This typically appears next to the hostname
// in a /WHOIS
$this->config["realname"] = "eZ publish IRC Listening Post";

// IRC server to connect to
$this->config["server"] = "irc.freenode.net";

// Port the IRCd runs on, typically 6667.
$this->config["port"] = 6667;

// Password required to connect (if any)
$this->config["password"] = "";

// String of channels that the bot should join
// example: "#lame #lamer #lamest"
$this->config["chans"] = "#ezpublish";

// For channels that have keys, you can put them here.
//$this->config["keys"]["#lame"] = "lamekey";
//$this->config["keys"]["#lamer"] = "lamerkey";
//$this->config["keys"]["#lamest"] = "lamestkey";

// Theme
// See include/themes.php for the available themes, and how to add/install
// your own. 
$this->config["theme"] = "irssi";

// Logging
// IQ will keep an IQ-current.log and a IQ-yesterday.log of all console messages (not debug)
// true for on, false for off
$this->config["log"] = true;

// Standard trigger prefix used for public commands
//   eg: ".dns test.com" uses a period for a prefix
// Defaults to "." 
$this->config["prefix"] = ".";

// Allow the bot's nickname with ": ", ", ", or "; " to be used as a prefix
//   eg: "botnick: dns test.com"
$this->config["nickasprefix"] = true;

// Do not require a prefix for private messages
// true does not require, false requires
$this->config["privnoprefix"] = true;

// Modules
// These files are loaded at runtime and can be reloaded with a rehash
// example: $this->loadmodule("modules/mymodule.php");
//$this->loadmodule("modules/acronym.php");
//$this->loadmodule("modules/automode.php");
//$this->loadmodule("modules/dictionary.php");
//$this->loadmodule("modules/dns.php");
//$this->loadmodule("modules/gametiger.php");
//$this->loadmodule("modules/google.php");
//$this->loadmodule("modules/opme.php");
//$this->loadmodule("modules/weather.php");
//$this->loadmodule("modules/whitepages.php");
$this->loadmodule("modules/IQ.php");

// Users *** IMPORTANT ***
// This configuration section controls who the bot will recognize. The masks
// are separated by spaces, and should match a wildcard on the target's
// hostmask. Hostmask format: nick!ident@host
//
// NOTE: as of 0.9.0RC4, regexp compatibility has been removed in favor
//       of simple wildcard usage. Regexps and may not work as expected.
//
// Wildcard usage:
//   *: match any number of any characters (including zero)
//   #: matches a digit (0-9)
//   &: matches a letter (a-z)
//   %: matches a single character (letter, digit, symbol)
//
//  Advanced wildcard usage:
//   +: matches one or more. Ex: "#+" will match #, ##, ###, etc.
//
// Available flags:
//	m: master/moderator: allow user to perform IRC-based comments (join,part,say,msg,etc)
//   n: owner of the bot, highest level (needed for commands like eval)
//   o: operator; will be opped by default in any controlled channel
//      by IQ std module
//   r: ability to rehash (IQ std module)
//   s: ability to restart the bot/save bot config (IQ std module)
//   
// There is no ranking of flags, so the "n" flag does not imply all lower flags.
//
// example: $this->adduser("handle","masks","flags");
//$this->adduser("f0rked","f0rked!*@godfather.f0rked.com *@*.f0rked.com *@192.168.0.#+","srmon");
//$this->adduser("f0rked","*!f0rked@*.f0rked.com","srmon");

// Remove the following line if you'd like your bot to work
// die("You didn't edit your config file. Bad admin!\n");

// Number of seconds to wait before attempting a reconnect after being disconnected
$this->config["reconnect_sleep"] = 10;

// Turn debugging on or off. With debugging, the bot console will announce
// much more information, useful for IQ development.
// 0 is off, 1 is on.
$this->config["debug"] = 0;

// Delay between lag messages. The bot will disconnect and reconnect if a
// single lag message is not received.
$this->config["lagdelay"] = 30;

// Join channel delay. Will check if bot is in not in all channels it should
// be at this interval in seconds.
// $this->config["joindelay"] = 60;
$this->config["joindelay"] = 45;

// Max number of users a channel can have before the bot will avoid executing a /WHO
// If this number is too high, on some networks the bot may attempt to receive too
// much information at once, and flood off.
$this->config["wholimit"] = 100;
?>
