<?php
//
// Jordan's PHP IRC Bot class
//
class MB_Core {
	
	var $conf;
	var $con;
	var $users; // currently logged in users
	var $joined;
	var $reconnect = true; // Allow reconnects?
	var $logging_enable = 0;
	var $logging_fp;
	var $channel_users;
	var $google_key;
	
	//
	// Constructor
	//
	function MB_Core ($server, $nick, $port, $name)
	{
		$this->conf = array();
		$this->conf['server']     = $server;
		$this->conf['nick']       = $nick;
		$this->conf['port']       = $port;
		$this->conf['name']       = $name;
		$this->conf['log_dir'] = "./";

		$this->conf['user_session_length'] = 3600; // seconds a user's session lasts 
		
		// Reset some needed variables/resources
		$this->clean();
	}
	
	//
	// Used in preparation for restart. A 'selective' constructor, if you will.
	//
	function clean()
	{
		$this->con = array();
		$this->users = array(array());
		$this->joined = array(); // array of channels currently in.
		$this->logging_fp = array();
		$this->channel_users = array(array());
	}
	
	//
	// Connects to a server
	//
	function connect()
	{
		/* Connect to the irc server */
		$this->con['socket'] = fsockopen($this->conf['server'], $this->conf['port']);
		
		/* Check that we have connected */
		if (!$this->con['socket'])
		{
			$this->m_print ("Could not connect to: ". $this->conf['server'] ." on port ". $this->conf['port']);
			return false;
		}
		
		/* Send the username and nick */
		$this->send("USER ". $this->conf['nick'] ." codedemons.net codedemons.net :". $this->conf['name']);
		$this->send("NICK ". $this->conf['nick'] ." codedemons.net");
		
		/* Here is the loop. Read the incoming data (from the socket connection) */
		while (!feof($this->con['socket']))
		{
			$this->con['buffer']['all'] = trim(fgets($this->con['socket'], 4096));
			
			$this->m_print (date("[d/m @ H:i]")."<- ".$this->con['buffer']['all'] ."\n");
			
			// If PINGed, PONG
			if(substr($this->con['buffer']['all'], 0, 6) == 'PING :')
			{
				/* PONG : is followed by the line that the server
				sent us when PINGing */
				$this->send('PONG :'.substr($this->con['buffer']['all'], 6));
				
				/* The next time we get here, it will NOT be the firstTime */
				return true;
			}
		}
	}
		
	//
	// Joins the specified channel
	//
	function join($channel)
	{
		$this->send("JOIN ". $channel);
		$this->joined[] = $channel;
	}
	
	//
	// Listens for commands
	//
	function listen()
	{
		/* Here is the loop. Read the incoming data (from the socket connection) */
		while (!feof($this->con['socket']))
		{
			$this->con['buffer']['all'] = trim(fgets($this->con['socket'], 4096));
			
			if (strlen($this->con['buffer']['all']) <= 0)
				continue;

			$this->m_print (date("[d/m @ H:i]")."<- ".$this->con['buffer']['all']);
			
			// If PINGed, PONG
			if(substr($this->con['buffer']['all'], 0, 6) == 'PING :')
			{
				$this->send('PONG :'.substr($this->con['buffer']['all'], 6));
			}
			// No ping, parse input.
			elseif ($old_buffer != $this->con['buffer']['all'])
			{
				// make sense of the buffer
				$this->parse_buffer();
				
				// now process any commands issued to the bot
				$this->process_commands();				
			}
			$old_buffer = $this->con['buffer']['all'];
		}
	}
	
	//
	// Process the user's commands
	//
	function process_commands()
	{
		// Take this line of text and see if it is a command
		$tmp = explode(" ", $this->con['buffer']['text'], 2);
		$first_word = $tmp[0];
		
		// A command could be ".time".
		// Ignoring the .
		$command = substr($first_word, 1);
		
		// $command is a command. DO IT!
		// u_ denotes a function that can be invoked by the User.
		$function = "u_".$command;
		
		// If the function exists, run it.
		if (method_exists($this, $function))
			$this->$function($this->con['buffer']['text']);
	}
	
	//
	// Make sense of the buffer. Determine channel, sender, etc.
	//
	function parse_buffer()
	{
		
		/*
		:username!~identd@hostname JOIN :#php
		:username!~identd@hostname PRIVMSG #PHP :action text
		:username!~identd@hostname command channel :text
		*/
		/*
		When a list of usernames come:
		:ChanServ!ChanServ@Services.GameSurge.net NOTICE molobot :200    ammoboi      Here                      Normal
		:ChanServ!ChanServ@Services.GameSurge.net NOTICE molobot :200    Fam^         4 hours and 18 minutes    Normal
		:ChanServ!ChanServ@Services.GameSurge.net NOTICE molobot :200    lakario      1 week and 1 day          Normal
		:ChanServ!ChanServ@Services.GameSurge.net NOTICE molobot :200    molotov      Here                      Normal
		:ChanServ!ChanServ@Services.GameSurge.net NOTICE molobot :200    Paradigm     12 minutes and 30 seconds Normal

		*/
	
		$buffer = $this->con['buffer']['all'];
		$buffer = explode(" ", $buffer, 4);
		
		/* Get username */
		$buffer['username'] = substr($buffer[0], 1, strpos($buffer['0'], "!")-1);
		
		/* Get identd */
		$posExcl = strpos($buffer[0], "!");
		$posAt = strpos($buffer[0], "@");
		$buffer['identd'] = substr($buffer[0], $posExcl+1, $posAt-$posExcl-1); 
		$buffer['hostname'] = substr($buffer[0], strpos($buffer[0], "@")+1);
		
		/* The user and the host, the whole shabang */
		$buffer['user_host'] = substr($buffer[0],1);
		
		/* Isolate the command the user is sending from
		the "general" text that is sent to the channel
		This is  privmsg to the channel we are talking about.
		
		We also format $buffer['text'] so that it can be logged nicely.
		*/
		switch (strtoupper($buffer[1]))
		{
			case "JOIN":
			   	$buffer['text'] = "*JOINS: ". $buffer['username']." ( ".$buffer['user_host']." )";
				$buffer['command'] = "JOIN";
				$buffer['channel'] = "unknown";
			   	break;
			case "QUIT":
			   	$buffer['text'] = "*QUITS: ". $buffer['username']." ( ".$buffer['user_host']." )";
				$buffer['command'] = "QUIT";
				$buffer['channel'] = "unknown";
			   	break;
			case "NOTICE":
			   	$buffer['text'] = "*NOTICE: ". $buffer['username'];
				$buffer['command'] = "NOTICE";
				$buffer['channel'] = substr($buffer[2], 1);
			   	break;
			case "PART":
			  	$buffer['text'] = "*PARTS: ". $buffer['username']." ( ".$buffer['user_host']." )";
				$buffer['command'] = "PART";
				$buffer['channel'] = "unknown";
			  	break;
			case "MODE":
			  	$buffer['text'] = $buffer['username']." sets mode: ".$buffer[3];
				$buffer['command'] = "MODE";
				$buffer['channel'] = $buffer[2];
			break;
			case "NICK":
				$buffer['text'] = "*NICK: ".$buffer['username']." => ".substr($buffer[2], 1)." ( ".$buffer['user_host']." )";
				$buffer['command'] = "NICK";
				$buffer['channel'] = "unknown";
			break;
			
			default:
				// it is probably a PRIVMSG
				$buffer['command'] = $buffer[1];
				$buffer['channel'] = $buffer[2];
				if (strpos($buffer['channel'], "#") === false)
				{
					// Looks like it was from another person.
					$buffer['channel'] = $buffer['username'];
				}
				$buffer['text'] = substr($buffer[3], 1);	
			break;	
		}
		$this->con['buffer'] = $buffer;
	}
	
	//
	// Take a message and channel and send a PM to it.
	//
	function pm($message, $channel = "")
	{
		// If a channel was defined, use it, else use the channel the command came from.
		$channel = ($channel == "") ? $this->con['buffer']['channel'] : $channel;
		$pm = 'PRIVMSG '. $channel .' :'.$message;
		$this->send($pm);
	}
	
	// Like print(), but can be used to output to a file instead of the console.
	function m_print ($string)
	{
		$string = $string."\n";
		print($string);
		$this->log($string, $this->conf['log_dir'] ."logs.txt");
	}
	
	//
	// Logs the line to specified file
	//
	function log($string, $file)
	{
		// If logging is disabled
		if ($this->logging_enable == 0)
		{
			return;
		}
		
		// If fp for this file doesn't exist, create it.
		if (! isset($this->logging_fp[$file]))
		{
			// Create the filepointer
			if ( ! ($this->logging_fp = fopen($file, "a")))
			{
				print("Could not open ". $file ." for appending.");
				return;
			}
		}
		
		if (! fwrite($this->logging_fp, $string))
		{
			print("Could not write to file '". $file ."' for logging.");
		}
	}
	
	//
	// Enables/Disables logging to file
	//
	function logging_enable($bool)
	{
		// Enable logging
		if ($bool == 1)
		{
			$this->logging_enable = 1;
		}
		else
		{ 
			$this->logging_enable = 0;
			@fclose($this->logging_fp);
			unset($this->logging_fp);
		}
	}
	
	/* Accepts the command as an argument, sends the command
	to the server, and then displays the command in the console
	for debugging */
	function send($command)
	{
		/* Send the command. Think of it as writing to a file. */
		fputs($this->con['socket'], $command."\n\r");
		/* Display the command locally, for the sole purpose
		of checking output. (line is not actually not needed) */
		$this->m_print (date("[d/m @ H:i]") ."-> ". $command. "\n\r");
		
	}
	
	//
	// Just formats a PM
	//
	function format($type, $msg)
	{
		return "[".$type."] ".$msg;
	}
	
	//
	// Determine whether specified user meets an access level
	//
	function has_access($user_host, $level)
	{
		// Check that they are in fact logged in
		if ($this->users[$user_host]['time'] + $this->conf['user_session_length'] >= time())
		{
			// Session not expired. They are logged in.
			if ($this->users[$user_host]['level'] >= $level)
			{
				return true;
			}
		}
		return false;
	}
	
	// Begin user-available functions
	// -------------------------------------------------------------------------
	//
	
	//
	// .time Returns current time.
	//
	function u_time($text)
	{
		$this->pm($this->format("Time", date("F j, Y, g:i a", time())));
	}
	
	//
	// .nick Changes the bot's nick on the fly.
	// Syntax: .nick new_nick
	function u_nick($text)
	{
		$args = explode(" ", $text, 2);
		// Check that this user has access of 10 (required for this operation)
		if ($this->has_access($this->con['buffer']['user_host'], 10))
		{	
			$this->send("NICK ". $args[1]);
			$this->conf['nick'] = $args[1];
		}
		else 
		{
			$this->pm("Access Denied");
		}
	}
	
	//
	// .noob Returns a message for beginners
	//
	function u_noob($text)
	{
		$args = explode(" ", $text, 2);
		$name = (!empty($args[1])) ?  " ". $args[1] : "";
		$this->pm($this->format("Beginner Help", "Welcome".$name.", Some tutorial sites: www.codedemons.net, www.zend.com, www.phpbuilder.com, www.php.net"));
	}
	
	//
	// .pm Displays a reminder about PMing OPs
	//
	function u_oppm($text)
	{	
		$this->pm($this->format("Reminder","Please do not send PMs to ops/peons unless you have asked first."));
	}
	
	//
	// .search Returns the URL from the first google result
	//
	function u_search($text)
	{
		// Grab the search terms
		$terms = trim(substr($text, 7));
		if (empty($this->google_key))
		{
			$this->pm(format("Oops", "My owner hasn't given me a Google API Developer Key. See readme.txt"));
		}
		$key = $this->google_key;
		
		
	    // Needed for the search function
	    $parameters = array(
	       "key"         => $key,
	       "q"           => $terms,
	       "start"       => 0,
	       "maxResults"  => 1,
	       "filter"      => true,
	       "restrict"    => "",
	       "safeSearch"  => false,
	       "lr"          => "lang_en",
	       "ie"          => "",
	       "oe"          => ""
	    );
	    
	    $answer = google_search($parameters);
	    $this->pm($this->format("Results",$answer));
	}
	
	//
	// .php
	// Returns search results from php.net
	function u_php($text)
	{
		$tmp = explode(" ", $text, 2);
		$terms = $tmp[1];
		
		$this->u_search(".search site:php.net ". trim($terms));  
	}
	
	//
	// .cd
	// Returns search results form codedemons.net
	function u_cd($text)
	{
		$tmp = explode(" ", $text, 2);
		$terms = $tmp[1];
		
		$this->u_search(".search site:codedemons.net ". trim($terms));  
	}
	
	//
	// .login
	// login to the bot
	function u_login($text)
	{
		$tmp = explode(" ", $text, 3);
		$username = $tmp[1];
		$password = $tmp[2];
		
		$file = file("passwords.txt");
		// If the login is valid
		if (in_array($username.",".$password, $file))
		{
			$this->users[$this->con['buffer']['user_host']]['time'] = time();
			// Give every valid use a access level of 10 (for now)
			$this->users[$this->con['buffer']['user_host']]['level'] = 10;
			$this->pm("Logged In. (". $username .". logged in as ". $this->con['buffer']['user_host'] .". Auto-logout in ". $this->conf['user_session_length'] ." seconds.)");
		}
		else
		{
			$this->pm("Invalid username password combination.");
		}
	}
	
	//
	// .identify
	// Identify with authserv@services.gamesurge.net
	function u_identify($text)
	{
		// Text comes in like: .identify authserv@services.gamesurge.net molotov password
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		
		$tmp = explode(" ", $text);
		if (count($tmp) != 4)
		{
			$this->pm("Syntax: .identify authserv@services.gamesurge.net molotov password");
			return;
		}

		$authserv = $tmp[1];
		$handle = $tmp[2];
		$pass = $tmp[3];
		
		$pm = "identify ".$handle." ".$pass;
		$this->pm($pm, $authserv);
		$this->pm("Command sent to ". $authserv ." was: ". $pm);
	}
	
	
	//
	// .help
	// Display a list of functions
	function u_help($text)
	{
		$basic = array('.time', '.noob','.search','.php','.login', '.cd');
		$basic = implode(", ", $basic);
		
		$admin = array('.restart', '.join', '.part', '.say', '.quit', '.identify', '.logging');
		$admin = implode(", ", $admin);
		
		$msg = "[Functions] ". $basic;
		if ($this->has_access($this->con['buffer']['user_host'], 10))
		{
			$msg .= ", ". $admin;
		}
		$this->pm($msg);
	}
	
	//
	// .join
	// Join a specific channel
	function u_join($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		$tmp = explode(" ", $text, 2);
		$chan = $tmp[1];
		if (strpos($chan, "#") === 0)
		{
			$this->join($chan);
			return;
		}
		$this->pm("Syntax: .join #channel");
	}
	
	//
	// .part
	// part a given channel
	function u_part($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		$tmp = explode(" ", $text, 2);
		$chan = $tmp[1];
		if (strpos($chan, "#") === 0)
		{
			$this->send("PART ". $chan);
			// We are no longer in this channel.
			for($i=0;$i<count($this->joined);$i++)
			{
				if ($this->joined[$i] == $chan)
				{
					unset($this->joined[$i]);
					break;
				}
			}
			return;
		}
		$this->pm("Syntax: .part #channel");
	}
	
	//
	// .say
	// Say something to a channel
	function u_say($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		
		$tmp = explode(" ", $text, 3);
		$chan = $tmp[1];
		$msg = $tmp[2];
		// Are we in this channel?
		if (in_array($chan, $this->joined))
		{
			$this->pm($msg, $chan);
		}
		else 
		{
			$this->pm("Syntax: .say #channel comments. I must be in ". $chan ." before I can say something in it.");
		}
	}
	
	//
	// .pm
	// Say something to a person
	function u_pm($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		
		$tmp = explode(" ", $text, 3);
		if (count($tmp != 3))
		{
			$this->pm("Syntax: .pm person message");
			return;
		}
		$chan = $tmp[1];
		$msg = $tmp[2];
		$this->pm($msg, $chan);
		$this->pm("Sent to ". $chan);
	}
	
	//
	// Disconnect
	//
	function u_disconnect($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		$this->pm("Disconnecting...");
		$this->reconnect = false; // Make sure we do NOT try to reconnect
		$this->send("QUIT Bye.");
	}
	
	//
	// .restart
	// Restarts the bot.
	function u_restart($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		$this->pm("Restarting...");
		$this->reconnect = true; // Make sure we do try to reconnect
		$this->send("QUIT Restarting.");
	}
	
	//
	// .logout
	// Logs out the current user.
	function u_logout($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 1))
		{
			$this->pm("Access Denied");
			return;
		}
		$this->pm("Logged Out. (". $this->con['buffer']['user_host'] .")");
		unset ($this->users[$this->con['buffer']['user_host']]);
	}
	
	//
	// .logging
	// Enable or disable logging functionality. Syntax: .logging 0
	function u_logging($text)
	{
		if (! $this->has_access($this->con['buffer']['user_host'], 10))
		{
			$this->pm("Access Denied");
			return;
		}
		$tmp = explode(" ", $text, 2);
		if (count($tmp) != 2 || ($tmp[1] != 1 && $tmp[1] != 0))
		{
			$this->pm("Enable Logging. (1=enable, 0=disable) Syntax: .logging 0");
			return;
		}
		$this->logging_enable($tmp[1]);
		$enabled_disabled = ($tmp[1] == 1) ? "enabled" : "disabled";
		$this->pm("Logging: ". $enabled_disabled);
	}
	
	// End user-available functions
	// -------------------------------------------------------------------------
	//
}

require_once("nusoap.php");

function google_search($parameters)
{

   $soapclient = new soapclient("http://api.google.com/search/beta2"); // [1]
   $result = $soapclient->call("doGoogleSearch", $parameters, "urn:GoogleSearch");
   $searchtime = $result['searchTime'];
   $begin = $start + 1;
   $end = $start + $parameters['maxResults'];
   $total = $result['estimatedTotalResultsCount'];
   
   if ($total > 0)
   {
      $result = $result['resultElements'];
   
      for ($i = 0; $i < $parameters['maxResults']; $i++)
      {
         $element = $result[$i];
         $url = $element['URL'];
         $title = $element['title'];
         $snippet = $element['snippet']; // [2]
         $out .= $url ." ";
      }
      return $out;
   }
   else
   {
      return "No Results";
   }
}
?>