#!/usr/bin/php
<?php

set_time_limit( 0 );

print( "Starting article import\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );
include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

include_once( 'kernel/classes/ezcontentobject.php' );

include_once( "lib/ezxml/classes/ezxml.php" );
include_once( 'ez22to30xmlimport.php' );

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

global $articleCount;
$articleCount = 0;
global $databasePrefix;
$databasePrefix = "";

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
    $databasePrefix = $databasePrefix . "_";
}

// Could set import range
$articleList =& getAllarticles( 0, 10000 );

foreach ( $articleList as $article )
{
    addArticle( $article );
}

function &getAllarticles( $minArticleID, $maxArticleID )
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$articleArray = $db->arrayQuery( "SELECT eZArticle_Article.ID, eZArticle_Article.Name, eZArticle_Article.Contents, eZArticle_Article.AuthorID,
                                             eZArticle_Article.Modified, eZArticle_Article.Created, eZArticle_Article.Published, eZArticle_Article.TopicID,
                                             eZArticle_Article.Discuss, eZArticle_ArticleCategoryLink.CategoryID, eZArticle_ArticleCategoryLink.Placement,
                                             eZArticle_Article.IsPublished
	                                  FROM
	                                         eZArticle_Article, eZArticle_ArticleCategoryLink
	                                  WHERE
                                             eZArticle_Article.ID = eZArticle_ArticleCategoryLink.ArticleID
                                        AND
	                                         eZArticle_Article.ID >= $minArticleID AND eZArticle_Article.ID < $maxArticleID
                                        AND  eZArticle_ArticleCategoryLink.CategoryID != 0
                                      ORDER BY eZArticle_Article.ID ASC" );
	return $articleArray;
}

function addArticle( &$article )
{
    global $databasePrefix;
    global $articleCount;
    $articleCount++;
    if ( ( $articleCount % 200 ) == 0 )
    {
	    print( "\n  ### eZ publish cache reset\n" );
        global $eZContentObjectContentObjectCache;
        unset ( $eZContentObjectContentObjectCache );
        global $eZContentObjectDataMapCache;
        unset( $eZContentObjectDataMapCache );
    }

    // If 2.2 article has illegal xml format, add these articles to the list. The import script will import the article
    // with empty content
    $badArticleIDList = array();

    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	//fetch article class
	$class =& eZContentClass::fetch( 2 );
    unset( $contentObject );
    $articleID = $article['ID'];
    $articleName = $article['Name'];
    $articleContent = $article['Contents'];
    $articleAuthorID = $article['AuthorID'];
    $articleModified = $article['Modified'];
    $articleCreated = $article['Created'];
    $articlePublished = $article['Published'];
    //$articleKeywords = $article['Keywords'];
    $articleCategoryID = $article['CategoryID'];
    $articleTopicID = $article['TopicID'];
    $articleDiscuss = $article['Discuss'];
    $articlePlaceMent = $article['Placement'];
    $articleIsPublished = $article['IsPublished'];

    print(  "import article " . $articleID . "\n" );

    if ( $databasePrefix != "" )
    {
        $remoteID = $databasePrefix  . "article_article_" . $articleID;
        $remoteCategoryID =  $databasePrefix . "article_category_" . $articleCategoryID;
        $remoteUserID = $databasePrefix . "user_" . $articleAuthorID;
    }
    else
    {
        $remoteID = "article_article_" . $articleID;
        $remoteCategoryID = "article_category_" . $articleCategoryID;
        $remoteUserID = "user_" . $articleAuthorID;
    }

    // Check if the article has been imported.
    $existNodeIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject
                                           WHERE remote_id = '$remoteID'" );

    if ( $existNodeIDArray == null )
    {
        // Find parent node
        $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id, ezcontentobject.section_id FROM ezcontentobject, ezcontentobject_tree
                                           WHERE ezcontentobject.remote_id = '$remoteCategoryID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );

        $parentNodeID = $parentNodeIDArray[0]['node_id'];
        $parentSectionID = $parentNodeIDArray[0]['section_id'];

        // Find current user id
        $userIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject WHERE remote_id = '$remoteUserID'" );

        $userID = $userIDArray[0]['id'];

        // If no exist user, set it to administrator.
        if ( $userID == null )
            $userID = 14;

        if ( !$articleIsPublished )
            $userID = 14;

        if ( $userID != null )
        {
            // Create object by user id in section 1
            $contentObject =& $class->instantiate( $userID, 1 );
            $contentObject->setAttribute('remote_id', $remoteID );
            $contentObject->setAttribute( 'name', $articleName );

            // Find related objects
            $relatedImages = $db->arrayQuery( "SELECT * FROM eZArticle_ArticleImageLink WHERE ArticleID = '$articleID'" );

            if ( $relatedImages != null )
            {
                foreach ( $relatedImages as $relatedImage )
                {
                    $imageID = $relatedImage['ImageID'];
                    $remoteImageID = $databasePrefix . "image_" . $imageID;
                    $objectIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject
                                                   WHERE ezcontentobject.remote_id = '$remoteImageID'" );
                    $objectID = $objectIDArray[0]['id'];
                    $contentObject->addContentObjectRelation( $objectID, 1 );
                }
            }

            $relatedFiles = $db->arrayQuery( "SELECT * FROM eZArticle_ArticleFileLink WHERE ArticleID = '$articleID'" );

            if ( $relatedFiles != null )
            {
                foreach ( $relatedFiles as $relatedFile )
                {
                    $fileID = $relatedFile['FileID'];
                    $remoteFileID = $databasePrefix . "file_" . $fileID;
                    $objectIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject
                                                   WHERE ezcontentobject.remote_id = '$remoteFileID'" );
                    $objectID = $objectIDArray[0]['id'];
                    $contentObject->addContentObjectRelation( $objectID, 1 );
                }
            }

            $nodeAssignment =& eZNodeAssignment::create( array(
                                                             'contentobject_id' => $contentObject->attribute( 'id' ),
                                                             'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                             'parent_node' => $parentNodeID,
                                                             'sort_field' => 2,
                                                             'sort_order' => 0,
                                                             'is_main' => 1
                                                             )
                                                         );
            $nodeAssignment->store();

            $version =& $contentObject->version( 1 );
            $version->setAttribute( 'modified', $articleModified );
            $version->setAttribute( 'created', $articleCreated );
            $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
            $version->store();

            $contentObjectID = $contentObject->attribute( 'id' );
            $contentObjectAttributes =& $version->contentObjectAttributes();

            $contentObjectAttributes[0]->setAttribute( 'data_text', $articleName );
            $contentObjectAttributes[0]->store();


            if ( $articleDiscuss == 1 )
            {
                $contentObjectAttributes[4]->setAttribute( 'data_int', 1 );
                $contentObjectAttributes[4]->store();
            }

            $contents = $articleContent;
            $xml = new eZXML();
            // replace \n with <br />
            $contents = str_replace( "\r\n\r\n\r\n\r\n", "<p /><p />", $contents );
            $contents = str_replace( "\n\n\n\n", "<p /><p />", $contents );
            $contents = str_replace( "\n\n", "<p />", $contents );
            $contents = str_replace( "\r\n\r\n", "<p />", $contents );
            $contents = str_replace( "\r\n", "<br />", $contents );
            $contents = str_replace( "\n", "<br />", $contents );
            $contents = str_replace( "&lt;br&gt;", "<literalbr />", $contents );
            $contents = str_replace( "&lt;BR&gt;", "<literalbr />", $contents );
            $contents = str_replace( "&lt;p&gt;", "<literalp />", $contents );
            $contents = str_replace( "&lt;P&gt;", "<literalp />", $contents );

            if ( !in_array( $articleID,  $badArticleIDList ) )
            {
                $inputDOM = $xml->domTree( $contents, array( 'CharsetConversion' => false ) );

                $converter = new eZ22To30XMLImport( $articleID, $databasePrefix );
                $inputText = $converter->convertTo22InputXML( $inputDOM );

                $introData = "<section xmlns:image='http://ez.no/namespaces/ezpublish3/image/' xmlns:xhtml='http://ez.no/namespaces/ezpublish3/xhtml/' xmlns:custom='http://ez.no/namespaces/ezpublish3/custom/' >";
                $introData .= "<paragraph>";
                $introData .= $inputText[0];
                $introData .= "</paragraph>";
                $introData .= "</section>";

                include_once( "kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php" );
                $dumpdata = "";
                $simplifiedXMLInput = new eZSimplifiedXMLInput( $dumpdata, null, null );

                $introData = $simplifiedXMLInput->convertInput( $introData );
                $intro = $introData[0]->toString();
                $intro = preg_replace( "#<paragraph> </paragraph>#", "<paragraph>&nbsp;</paragraph>", $intro );
                $intro = str_replace ( "<paragraph />" , "", $intro );
                $intro = str_replace ( "<line />" , "", $intro );
                $intro = str_replace ( "<paragraph></paragraph>" , "", $intro );
                $intro = preg_replace( "#<paragraph>&nbsp;</paragraph>#", "<paragraph />", $intro );
                $intro = preg_replace( "#<paragraph></paragraph>#", "", $intro );

                $intro = preg_replace( "#[\n]+#", "", $intro );
                $intro = preg_replace( "#&lt;/line&gt;#", "\n", $intro );
                $intro = preg_replace( "#&lt;paragraph&gt;#", "\n\n", $intro );
                $contentObjectAttributes[1]->setAttribute( 'data_text', $intro );
                $contentObjectAttributes[1]->store();

                $bodyData = "<section xmlns:image='http://ez.no/namespaces/ezpublish3/image/' xmlns:xhtml='http://ez.no/namespaces/ezpublish3/xhtml/' xmlns:custom='http://ez.no/namespaces/ezpublish3/custom/' >";
                $bodyData .= "<paragraph>";
                $bodyData .= $inputText[1];
                $bodyData .= "</paragraph>";
                $bodyData .= "</section>";
                $bodyData = $simplifiedXMLInput->convertInput( $bodyData );
                $body = $bodyData[0]->toString();
                $body = preg_replace( "#<paragraph> </paragraph>#", "<paragraph>&nbsp;</paragraph>", $body );
                $body = str_replace ( "<paragraph />" , "", $body );
                $body = str_replace ( "<line />" , "", $body );
                $body = str_replace ( "<paragraph></paragraph>" , "", $body );
                $body = preg_replace( "#<paragraph>&nbsp;</paragraph>#", "<paragraph />", $body );
                $body = preg_replace( "#<paragraph></paragraph>#", "", $body );

                $body = preg_replace( "#[\n]+#", "", $body );
                $body = preg_replace( "#&lt;/line&gt;#", "\n", $body );
                $body = preg_replace( "#&lt;paragraph&gt;#", "\n\n", $body );
                $contentObjectAttributes[2]->setAttribute( 'data_text', $body );
                $contentObjectAttributes[2]->store();
            }

            if ( $articleIsPublished )
            {
                include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
                $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                         'version' => 1 ) );
                $contentObject->setAttribute('modified', $articleModified );
                $contentObject->setAttribute('published', $articlePublished  );
                $contentObject->setAttribute('section_id', $parentSectionID );
                $contentObject->store();
                // Get node id for this folder
                $nodeIDArray = $db->arrayQuery( "SELECT node_id FROM ezcontentobject_tree
                                         WHERE contentobject_id = '$contentObjectID' AND contentobject_version = 1" );
                $articleNodeID = $nodeIDArray[0]['node_id'];
                $db->query( "UPDATE ezcontentobject_tree SET priority=$articlePlaceMent WHERE node_id=$articleNodeID" );
            }
            else
            {
                $contentObject->setAttribute('modified', $articleModified );
                $contentObject->setAttribute('published', $articlePublished );
                $contentObject->setAttribute('section_id', $parentSectionID );
                $contentObject->store();
            }
        }
    }
    else
    {
        $isPublished = false;
        // Find parent node
        $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id, ezcontentobject.section_id FROM ezcontentobject, ezcontentobject_tree
                                               WHERE ezcontentobject.remote_id = '$remoteCategoryID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );

        $parentNodeID = $parentNodeIDArray[0]['node_id'];


        $contentObjectID = $existNodeIDArray[0]['id'];
        $contentObject =& eZContentObject::fetch( $contentObjectID );

        $publishedNodeArray =& $db->arrayQuery( "SELECT parent_node_id FROM ezcontentobject_tree
                                                 WHERE contentobject_id = '$contentObjectID' AND contentobject_version = 1" );

        foreach ( $publishedNodeArray as $publishedNode )
        {
            $publishedParentNodeID = $publishedNode['parent_node_id'];
            if ( $parentNodeID == $publishedParentNodeID )
                $isPublished = true;
        }

        if ( !$isPublished )
        {
            $nodeAssignment =& eZNodeAssignment::create( array(
                                                             'contentobject_id' => $contentObject->attribute( 'id' ),
                                                             'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                             'parent_node' => $parentNodeID,
                                                             'sort_field' => 2,
                                                             'sort_order' => 0,
                                                             'is_main' => 0
                                                             )
                                                         );
            $nodeAssignment->store();
        }

        $version =& $contentObject->version( 1 );
        $contentObjectAttributes =& $version->contentObjectAttributes();
        $version->setAttribute( 'modified', $articleModified );
        $version->setAttribute( 'created', $articleCreated );
        if ( $articleIsPublished )
            $version->setAttribute( 'status', EZ_VERSION_STATUS_PUBLISHED );
        else
            $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        // only update content.
        $contents = $articleContent;
        $xml = new eZXML();
        // replace \n with <br />
        $contents = str_replace( "\r\n\r\n\r\n\r\n", "<p /><p />", $contents );
        $contents = str_replace( "\n\n\n\n", "<p /><p />", $contents );
        $contents = str_replace( "\n\n", "<p />", $contents );
        $contents = str_replace( "\r\n\r\n", "<p />", $contents );
        $contents = str_replace( "\r\n", "<br />", $contents );
        $contents = str_replace( "\n", "<br />", $contents );
        $contents = str_replace( "&lt;br&gt;", "<literalbr />", $contents );
        $contents = str_replace( "&lt;BR&gt;", "<literalbr />", $contents );
        $contents = str_replace( "&lt;p&gt;", "<literalp />", $contents );
        $contents = str_replace( "&lt;P&gt;", "<literalp />", $contents );

        if ( !in_array( $articleID,  $badArticleIDList ) )
        {
            $inputDOM = $xml->domTree( $contents, array( 'CharsetConversion' => false ) );

            $converter = new eZ22To30XMLImport( $articleID, $databasePrefix );
            $inputText = $converter->convertTo22InputXML( $inputDOM );

            $introData = "<section xmlns:image='http://ez.no/namespaces/ezpublish3/image/' xmlns:xhtml='http://ez.no/namespaces/ezpublish3/xhtml/' xmlns:custom='http://ez.no/namespaces/ezpublish3/custom/' >";
            $introData .= "<paragraph>";
            $introData .= $inputText[0];
            $introData .= "</paragraph>";
            $introData .= "</section>";

            include_once( "kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php" );
            $dumpdata = "";
            $simplifiedXMLInput = new eZSimplifiedXMLInput( $dumpdata, null, null );

            $introData = $simplifiedXMLInput->convertInput( $introData );
            $intro = $introData[0]->toString();
            $intro = preg_replace( "#<paragraph> </paragraph>#", "<paragraph>&nbsp;</paragraph>", $intro );
            $intro = str_replace ( "<paragraph />" , "", $intro );
            $intro = str_replace ( "<line />" , "", $intro );
            $intro = str_replace ( "<paragraph></paragraph>" , "", $intro );
            $intro = preg_replace( "#<paragraph>&nbsp;</paragraph>#", "<paragraph />", $intro );
            $intro = preg_replace( "#<paragraph></paragraph>#", "", $intro );

            $intro = preg_replace( "#[\n]+#", "", $intro );
            $intro = preg_replace( "#&lt;/line&gt;#", "\n", $intro );
            $intro = preg_replace( "#&lt;paragraph&gt;#", "\n\n", $intro );
            $contentObjectAttributes[1]->setAttribute( 'data_text', $intro );
            $contentObjectAttributes[1]->store();

            $bodyData = "<section xmlns:image='http://ez.no/namespaces/ezpublish3/image/' xmlns:xhtml='http://ez.no/namespaces/ezpublish3/xhtml/' xmlns:custom='http://ez.no/namespaces/ezpublish3/custom/' >";
            $bodyData .= "<paragraph>";
            $bodyData .= $inputText[1];
            $bodyData .= "</paragraph>";
            $bodyData .= "</section>";
            $bodyData = $simplifiedXMLInput->convertInput( $bodyData );
            $body = $bodyData[0]->toString();
            $body = preg_replace( "#<paragraph> </paragraph>#", "<paragraph>&nbsp;</paragraph>", $body );
            $body = str_replace ( "<paragraph />" , "", $body );
            $body = str_replace ( "<line />" , "", $body );
            $body = str_replace ( "<paragraph></paragraph>" , "", $body );
            $body = preg_replace( "#<paragraph>&nbsp;</paragraph>#", "<paragraph />", $body );
            $body = preg_replace( "#<paragraph></paragraph>#", "", $body );

            $body = preg_replace( "#[\n]+#", "", $body );
            $body = preg_replace( "#&lt;/line&gt;#", "\n", $body );
            $body = preg_replace( "#&lt;paragraph&gt;#", "\n\n", $body );
            $contentObjectAttributes[2]->setAttribute( 'data_text', $body );
            $contentObjectAttributes[2]->store();

            $contentObject->setAttribute('modified', $articleModified );
            $contentObject->setAttribute('published', $articlePublished  );
            $contentObject->store();
        }
        if ( !$isPublished and $articleIsPublished )
        {
            $contentObject->setAttribute('remote_id', $remoteID );
            include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
            $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                         'version' => 1 ) );
            $contentObject->setAttribute('modified', $articleModified );
            $contentObject->setAttribute('published', $articlePublished  );
            $contentObject->store();

            // Get node id for this folder
            $nodeIDArray = $db->arrayQuery( "SELECT node_id FROM ezcontentobject_tree
                                         WHERE contentobject_id = '$contentObjectID' AND contentobject_version = 1" );
            $articleNodeID = $nodeIDArray[0]['node_id'];
            $db->query( "UPDATE ezcontentobject_tree SET priority=$articlePlaceMent WHERE node_id=$articleNodeID" );
        }
        else
        {
            $contentObject->setAttribute('modified', $articleModified );
            $contentObject->setAttribute('published', $articlePublished  );
            $contentObject->setAttribute('section_id', $parentSectionID );
            $contentObject->store();
        }
    }
}
?>
