#!/usr/bin/php
<?php

set_time_limit( 0 );

print( "Starting article comments import\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );
include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

global $databasePrefix;
$databasePrefix = "";

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
    $databasePrefix = $databasePrefix . "_";
}

global $messageCount;
$messageCount = 0;
$articleList =& hasCommentsArticleList( );
foreach ( array_keys( $articleList ) as $key )
{
    $article =& $articleList[$key];
    $articleID = $article['ArticleID'];
    $forumID = $article['ForumID'];
    addComment( $articleID, $forumID );
}

function &hasCommentsArticleList( )
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$articleArray = $db->arrayQuery( "SELECT *
	FROM
	  eZArticle_ArticleForumLink
    ORDER BY ArticleID" );
	return $articleArray;
}

function &topLevelArticleCommentList( $forumID )
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$commentArray = $db->arrayQuery( "SELECT *
	FROM
	  eZForum_Message
    WHERE
      ForumID='$forumID'
      AND Parent = 0" );
	return $commentArray;
}

function &messageSubTree( $forumID, $messageID, $threadID )
{
	$db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	$treeArray = $db->arrayQuery( "SELECT *
	FROM
	   eZForum_Message
	WHERE
	   ForumID = $forumID
       AND ThreadID = '$threadID'
       AND ID != '$messageID'
    ORDER BY PostingTime DESC" );
	return $treeArray;
}

function addComment( $articleID, $forumID )
{
    global $databasePrefix;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );

    // set remoteID
    if ( $databasePrefix != "" )
    {
        $remoteID = $databasePrefix . "article_article_" . $articleID;
    }
    else
    {
        $remoteID = "article_article_" . $articleID;
    }

    // Find parent Nodes .
    $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id FROM ezcontentobject, ezcontentobject_tree
                                           WHERE ezcontentobject.remote_id = '$remoteID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );
    if ( $parentNodeIDArray[0] != null )
    {
        $parentNodeID = $parentNodeIDArray[0]['node_id'];
    }
    $topLevelComments =& topLevelArticleCommentList( $forumID );

    if (  $parentNodeID != null )
    {
        addForumMessage( $topLevelComments, $parentNodeID );

        // Add children comments
        addChildrenMessage( $forumID, $parentNodeID );
    }
}

function addChildrenMessage( $forumID, $parentNodeID )
{
    global $databasePrefix;
	$db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );

	$childrenNode =& eZContentObjectTreeNode::subTree( false, $parentNodeID );

    foreach ( $childrenNode as $child )
	{
		$nodeID = $child->attribute('node_id');
		$contentObjectID = $child->attribute('contentobject_id');
		$contentObject =& eZContentObject::fetch($contentObjectID);
		$remoteID = $contentObject->attribute('remote_id');

        if ( $databasePrefix != "" )
        {
            $remoteID = str_replace( $databasePrefix, "", $remoteID );
        }

        list( $messageID, $threadID ) = split("_", $remoteID );
        $childMessages =& messageSubTree( $forumID, $messageID, $threadID );

        if( $childMessages != null )
		{
            addForumMessage( $childMessages, $nodeID );
		}
	}
}


function addForumMessage( $messages, $groupID )
{
    global $databasePrefix;
    global $messageCount;
    $messageCount++;
    if ( ( $messageCount % 200 ) == 0 )
    {
	    print( "\n  ### eZ publish cache reset\n" );
        global $eZContentObjectContentObjectCache;
        unset ( $eZContentObjectContentObjectCache );
        global $eZContentObjectDataMapCache;
        unset( $eZContentObjectDataMapCache );
    }
    $isImported = false;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	//fetch forum message class
	$class =& eZContentClass::fetch( 7 );
	foreach( $messages as $message )
	{
		unset( $contentObject );
		$topic = $message['Topic'];
		$body = $message['Body'];
		$remoteUserID =  $databasePrefix . "user_" . $message['UserID'];
		$threadID = $message['ThreadID'];
        $postingTime = $message['PostingTime'];
        $remoteMessageID = $message['ID'];

        // set remoteID with both message id and tree id
        $remoteID =  $databasePrefix . $remoteMessageID . "_" . $threadID;
        // Check if it exist
        $messageArray = $db->arrayQuery( "SELECT id FROM ezcontentobject WHERE remote_id = '$remoteID'" );

        if ( count( $messageArray ) != 0 )
        {
            $isImported = true;
        }
        // Find current user id
        $userIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject WHERE remote_id = '$remoteUserID'" );

        $userID = $userIDArray[0]['id'];

        if ( $userID != null and !$isImported )
        {
            // Create object by user id in section 1
            $contentObject =& $class->instantiate( $userID, 1 );
            $contentObject->setAttribute('remote_id', $remoteID );
            $nodeAssignment =& eZNodeAssignment::create( array(
                                                             'contentobject_id' => $contentObject->attribute( 'id' ),
                                                             'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                             'parent_node' => $groupID,
                                                             'sort_field' => 2,
                                                             'sort_order' => 0,
                                                             'is_main' => 1
                                                             )
                                                         );
            $nodeAssignment->store();

            $version =& $contentObject->version( 1 );
            $version->setAttribute( 'modified', $postingTime );
            $version->setAttribute( 'created', $postingTime );
            $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
            $version->store();

            $contentObjectID = $contentObject->attribute( 'id' );
            $contentObjectAttributes =& $version->contentObjectAttributes();

            $contentObjectAttributes[0]->setAttribute( 'data_text', $topic );
            $contentObjectAttributes[0]->store();

            $contentObjectAttributes[1]->setAttribute( 'data_text', $body );
            $contentObjectAttributes[1]->store();

            include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
            $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                         'version' => 1 ) );
            $contentObject->setAttribute('modified', $postingTime );
            $contentObject->setAttribute('published', $postingTime  );
            $contentObject->store();
        }
	}
}

?>
