#!/usr/bin/php
<?php

set_time_limit( 0 );

print( "Starting folder import\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );
include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

global $databasePrefix;
global $sectionMatchArray;
$sectionMatchArray = array();
$databasePrefix = "";

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
}

// Import all sections
include_once( "kernel/classes/ezsection.php" );
$sectionList =& sectionList();

foreach ( $sectionList as $section )
{
    $sectionName = $section['Name'];
    $sectionID = $section['ID'];
    $section = new eZSection( array( 'name' => $sectionName ) );
    $section->store();
    $newSectionID = $section->attribute( 'id' );
    $sectionMatchArray[] = array( 'oldID' => $sectionID, 'newID' => $newSectionID );
}

// Create some folders for future import.
if ( $databasePrefix != "" )
{
    $imageFolderNodeID = createFolder( $databasePrefix . " image folder", "Contain all images", $databasePrefix . "_image_main_folder" );
    $fileFolderNodeID = createFolder( $databasePrefix . " file folder", "Contain all files",  $databasePrefix . "_file_main_folder" );
    $mediaFolderNodeID = createFolder( $databasePrefix . " media folder", "Contain all medias",  $databasePrefix ."_media_main_folder" );
    $unassignedImageFolderNodeID = createFolder( $databasePrefix . " image unassigned", "Contain all unassigned images", $databasePrefix . "_image_unassigned_folder", $imageFolderNodeID );
    $unassignedFileFolderNodeID = createFolder( $databasePrefix . " file unassigned", "Contain all unassigned files", $databasePrefix . "_file_unassigned_folder", $fileFolderNodeID );
    $unassignedMediaFolderNodeID = createFolder( $databasePrefix . " media unassigned", "Contain all unassigned medias", $databasePrefix . "_media_unassigned_folder", $mediaFolderNodeID );
}
else
{
    $imageFolderNodeID = createFolder( "image folder", "Contain all images", "image_main_folder" );
    $fileFolderNodeID = createFolder( "file folder", "Contain all files", "file_main_folder" );
    $mediaFolderNodeID = createFolder( "media folder", "Contain all medias", "media_main_folder" );
    $unassignedImageFolderNodeID = createFolder( "image unassigned", "Contain all unassigned images", "image_unassigned_folder", $imageFolderNodeID );
    $unassignedFileFolderNodeID = createFolder( "file unassigned", "Contain all unassigned files", "file_unassigned_folder", $fileFolderNodeID );
    $unassignedMediaFolderNodeID = createFolder( "media unassigned", "Contain all unassigned medias", "media_unassigned_folder", $mediaFolderNodeID );
}

$articleFolderList =& articleFolderList( );

if ( $databasePrefix != "" )
{
    $articleFolderPrefix = $databasePrefix . "_" . "article_category_";
}
else
{
    $articleFolderPrefix = "article_category_";
}
foreach ( $articleFolderList as $folder )
{
    addFolder( $folder, $articleFolderPrefix, null, true );
}

$imageFolderList =& imageFolderList( );
if ( $databasePrefix != "" )
{
    $imageFolderPrefix = $databasePrefix . "_" . "image_category_";
}
else
{
    $imageFolderPrefix = "image_category_";
}

foreach ( $imageFolderList as $folder )
{
    addFolder( $folder, $imageFolderPrefix, $imageFolderNodeID );
}

$fileFolderList =& fileFolderList( );
if ( $databasePrefix != "" )
{
    $fileFolderPrefix = $databasePrefix . "_" . "file_category_";
}
else
{
    $fileFolderPrefix = "file_category_";
}

foreach ( $fileFolderList as $folder )
{
    addFolder( $folder, $fileFolderPrefix, $fileFolderNodeID );
}

$mediaFolderList =& mediaFolderList( );
if ( $databasePrefix != "" )
{
    $mediaFolderPrefix = $databasePrefix . "_" . "media_category_";
}
else
{
    $mediaFolderPrefix = "media_category_";
}
foreach ( $mediaFolderList as $folder )
{
    addFolder( $folder, $mediaFolderPrefix, $mediaFolderNodeID );
}

function &sectionList()
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$sectionArray = $db->arrayQuery( "SELECT *
	FROM
	   eZSiteManager_Section
    ORDER BY ID" );
	return $sectionArray;
}

function &articleFolderList( )
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$folderArray = $db->arrayQuery( "SELECT *
	FROM
	  eZArticle_Category
    ORDER BY ID" );
	return $folderArray;
}

function &imageFolderList()
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$folderArray = $db->arrayQuery( "SELECT *
	FROM
	  eZImageCatalogue_Category
    ORDER BY ID" );
	return $folderArray;
}

function &fileFolderList()
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$folderArray = $db->arrayQuery( "SELECT *
	FROM
	  eZFileManager_Folder
    ORDER BY ID" );
	return $folderArray;
}

function &mediaFolderList()
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$folderArray = $db->arrayQuery( "SELECT *
	FROM
	  eZMediaCatalogue_Category
    ORDER BY ID" );
	return $folderArray;
}

function addFolder( &$folder, $remotePrefix, $parentNodeID = null, $isArticleFolder = false )
{
    global $databasePrefix;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );

    $defaultID = 2;
    if ( $parentNodeID != null )
        $defaultID = $parentNodeID;

    //fetch folder class
	$class =& eZContentClass::fetch( 1 );

    unset( $contentObject );
    $folderID = $folder['ID'];
    $folderName = $folder['Name'];
    $folderDescription = $folder['Description'];
    $folderParentID = $folder['ParentID'];
    $folderOwnerID = $folder['OwnerID'];
    $folderSectionID = $folder['SectionID'];
    if ( $isArticleFolder )
    {
        $folderPlacement = $folder['Placement'];
        $folderSortMode = $folder['SortMode'];
    }

    if ( $databasePrefix != "" )
    {
        $remoteUserID = $databasePrefix . "_" . "user_" . $folderOwnerID;
    }
    else
    {
        $remoteUserID =  "user_" . $folderOwnerID;
    }

    // set remoteID
    $remoteID = $remotePrefix . $folderID;
    $remoteParentID = $remotePrefix . $folderParentID;

    // Find current user id
    $userIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject WHERE remote_id = '$remoteUserID'" );

    $userID = $userIDArray[0]['id'];

    // If no exist user, set it to administrator.
    if ( $userID == null )
        $userID = 14;

    // Find parent node id
    if ( $folderParentID == 0 )
        $parentNodeID = $defaultID;
    else
    {
        $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id FROM ezcontentobject, ezcontentobject_tree
                                          WHERE ezcontentobject.remote_id = '$remoteParentID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );

        $parentNodeID = $parentNodeIDArray[0]['node_id'];
    }

    $sortField = 2;
    $sortOrder = 1;

    if ( $isArticleFolder )
    {
        switch ( $folderSortMode )
        {
            case 1:
            {
                $sortField = 2;
            }
            break;
            case 2:
            {
                 $sortField = 9;
            }
            break;
            case 3:
            {
                 $sortField = 9;
                 $sortOrder = 0;
            }
            break;
            case 4:
            {
                $sortField = 8;
            }
            break;
            case 5:
            {
                $sortField = 3;
            }
            break;
        }
    }


    if ( $userID != null )
    {
        // Create object by user id in section 1
        $contentObject =& $class->instantiate( $userID, 1 );
        $contentObject->setAttribute('remote_id', $remoteID );
        $contentObject->setAttribute( 'name', $folderName );
        $nodeAssignment =& eZNodeAssignment::create( array(
                                                         'contentobject_id' => $contentObject->attribute( 'id' ),
                                                         'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                         'parent_node' => $parentNodeID,
                                                         'sort_field' => $sortField,
                                                         'sort_order' => $sortOrder,
                                                         'is_main' => 1
                                                         )
                                                     );
        $nodeAssignment->store();

        $version =& $contentObject->version( 1 );

        $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        $contentObjectID = $contentObject->attribute( 'id' );
        $contentObjectAttributes =& $version->contentObjectAttributes();

        $contentObjectAttributes[0]->setAttribute( 'data_text', $folderName );
        $contentObjectAttributes[0]->store();

        $inputData = "<?xml version=\"1.0\"?>";
        $inputData .= "<section>";
        $inputData .= "<paragraph>";
        $inputData .= $folderDescription;
        $inputData .= "</paragraph>";
        $inputData .= "</section>";

        include_once( "kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php" );
        $dumpdata = "";
        $simplifiedXMLInput = new eZSimplifiedXMLInput( $dumpdata, null, null );
        $inputData = $simplifiedXMLInput->convertInput( $inputData );
        $description = $inputData[0]->toString();
        $contentObjectAttributes[1]->setAttribute( 'data_text', $description );
        $contentObjectAttributes[1]->store();

        include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
        $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                     'version' => 1 ) );

        $folderNewSectionID = 1;
        global $sectionMatchArray;
        foreach ( $sectionMatchArray as $sectionMatch )
        {
            if ( $folderSectionID == $sectionMatch['oldID'] )
            {
                $folderNewSectionID = $sectionMatch['newID'];
            }

        }
        $contentObject->setAttribute('section_id', $folderNewSectionID );
        $contentObject->store();
        if ( $isArticleFolder )
        {
             // Get node id for this folder
            $nodeIDArray = $db->arrayQuery( "SELECT node_id FROM ezcontentobject_tree
                                         WHERE contentobject_id = '$contentObjectID' AND contentobject_version = 1" );
            $folderNodeID = $nodeIDArray[0]['node_id'];
            $db->query( "UPDATE ezcontentobject_tree SET priority=$folderPlacement WHERE node_id=$folderNodeID" );
        }
    }
}

function createFolder( $name, $description, $importCaption, $parentNodeID = 2 )
{
    $folderNodeID = 2;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );

    //fetch folder class
	$class =& eZContentClass::fetch( 1 );

    unset( $contentObject );
    $userID = 14;

    if ( $userID != null )
    {
        // Create object by user id in section 1
        $contentObject =& $class->instantiate( $userID, 1 );
        $contentObject->setAttribute( 'remote_id', $importCaption );
        $contentObject->setAttribute( 'name', $name );
        $nodeAssignment =& eZNodeAssignment::create( array(
                                                         'contentobject_id' => $contentObject->attribute( 'id' ),
                                                         'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                         'parent_node' => $parentNodeID,
                                                         'sort_field' => 7,
                                                         'sort_order' => 1,
                                                         'is_main' => 1
                                                         )
                                                     );
        $nodeAssignment->store();

        $version =& $contentObject->version( 1 );
        $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        $contentObjectID = $contentObject->attribute( 'id' );
        $contentObjectAttributes =& $version->contentObjectAttributes();

        $contentObjectAttributes[0]->setAttribute( 'data_text', $name );
        $contentObjectAttributes[0]->store();

        $inputData = "<?xml version=\"1.0\"?>";
        $inputData .= "<section>";
        $inputData .= "<paragraph>";
        $inputData .= $description;
        $inputData .= "</paragraph>";
        $inputData .= "</section>";

        include_once( "kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php" );
        $dumpdata = "";
        $simplifiedXMLInput = new eZSimplifiedXMLInput( $dumpdata, null, null );
        $inputData = $simplifiedXMLInput->convertInput( $inputData );
        $description = $inputData[0]->toString();
        $contentObjectAttributes[1]->setAttribute( 'data_text', $description );
        $contentObjectAttributes[1]->store();

        include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
        $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                     'version' => 1 ) );
        $contentObject->setAttribute('section_id', 1 );
        $contentObject->store();

        // Get node id for this folder
        $nodeIDArray = $db->arrayQuery( "SELECT node_id FROM ezcontentobject_tree
                                         WHERE contentobject_id = '$contentObjectID' AND contentobject_version = 1" );
        $folderNodeID = $nodeIDArray[0]['node_id'];
    }
    return $folderNodeID;
}
?>
