#!/usr/bin/php
<?php

set_time_limit( 0 );

print( "Starting image import\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );

include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

// Check for extension
include_once( 'lib/ezutils/classes/ezextension.php' );
include_once( 'kernel/common/ezincludefunctions.php' );
eZExtension::activateExtensions();
// Extension check end

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

global $databasePrefix;
$databasePrefix = "";

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
}

$imageList =& imageList();
foreach ( $imageList as $image )
{
    addImage( $image );
}

function &imageList()
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$imageArray = $db->arrayQuery( "SELECT *
	FROM
	  eZImageCatalogue_Image
    ORDER BY ID" );
	return $imageArray;
}

function addImage( &$image )
{
    global $databasePrefix;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	//fetch folder class
	$class =& eZContentClass::fetch( 5 );

    unset( $contentObject );
    $imageID = $image['ID'];
    $imageName = $image['Name'];
    $imageDescription = $image['Description'];
    $imageCreatedTime = $image['Created'];
    $imageFileName = $image['FileName'];
    $imageOriginalFileName = $image['OriginalFileName'];
    $imageCaption = $image['Caption'];
    $imageUserID = $image['UserID'];

    if ( $databasePrefix != "" )
    {
        $remoteUserID = $databasePrefix . "_" . "user_" . $imageUserID;
        $remoteID = $databasePrefix . "_" . "image_" . $imageID;
        $remoteParentIDPrefix =  $databasePrefix . "_";
        $unassignedImageFolderID = $databasePrefix . "_" . "image_unassigned_folder";
    }
    else
    {
        $remoteUserID =  "user_" . $imageUserID;
        $remoteID = "image_" . $imageID;
        $remoteParentIDPrefix = "";
        $unassignedImageFolderID = "image_unassigned_folder";
    }

    $remoteParentNodeArray = $db->arrayQuery( "SELECT * from eZImageCatalogue_ImageCategoryLink WHERE ImageID = '$imageID'" );

    $assignedNodes = array();
    if ( $remoteParentNodeArray != null )
    {
        // Find all parent node
        foreach ( $remoteParentNodeArray as $remoteParentNode )
        {
            $remoteParentID = $remoteParentIDPrefix . "image_category_" . $remoteParentNode['CategoryID'];
            // Find parent node id
            $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id FROM ezcontentobject, ezcontentobject_tree
                                                   WHERE ezcontentobject.remote_id = '$remoteParentID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );
            $parentNodeID = $parentNodeIDArray[0]['node_id'];
            $assignedNodes[] = $parentNodeID;
        }
    }
    else
    {
        // For those unassigned images, import to main image folder.
        $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id FROM ezcontentobject, ezcontentobject_tree
                                               WHERE ezcontentobject.remote_id = '$unassignedImageFolderID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );
        $parentNodeID = $parentNodeIDArray[0]['node_id'];
        $assignedNodes[] = $parentNodeID;
    }

    // Find current user id
    $userIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject WHERE remote_id = '$remoteUserID'" );

    $userID = $userIDArray[0]['id'];

    // If no exist user, set it to administrator.
    if ( $userID == null )
        $userID = 14;

    if ( $userID != null )
    {
        // Create object by user id in section 1
        $contentObject =& $class->instantiate( $userID, 1 );
        $contentObject->setAttribute('remote_id', $remoteID );
        $contentObject->setAttribute( 'name', $imageName );

        foreach ( $assignedNodes as $assignedNode )
        {
            $nodeAssignment =& eZNodeAssignment::create( array(
                                                         'contentobject_id' => $contentObject->attribute( 'id' ),
                                                         'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                         'parent_node' => $assignedNode,
                                                         'sort_field' => 2,
                                                         'sort_order' => 0,
                                                         'is_main' => 1
                                                         )
                                                     );
            $nodeAssignment->store();
        }

        $version =& $contentObject->version( 1 );
        $version->setAttribute( 'modified', $imageCreatedTime );
        $version->setAttribute( 'created', $imageCreatedTime );
        $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        $contentObjectID = $contentObject->attribute( 'id' );
        $contentObjectAttributes =& $version->contentObjectAttributes();

        $contentObjectAttributes[0]->setAttribute( 'data_text', $imageName );
        $contentObjectAttributes[0]->store();

        $inputData = "<?xml version=\"1.0\"?>";
        $inputData .= "<section>";
        $inputData .= "<paragraph>";
        $inputData .= $imageCaption;
        $inputData .= "</paragraph>";
        $inputData .= "</section>";

        include_once( "kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php" );
        $dumpdata = "";
        $simplifiedXMLInput = new eZSimplifiedXMLInput( $dumpdata, null, null );
        $inputData = $simplifiedXMLInput->convertInput( $inputData );
        $description = $inputData[0]->toString();
        $contentObjectAttributes[1]->setAttribute( 'data_text', $description );
        $contentObjectAttributes[1]->store();

        $contentObjectAttribute =& $contentObjectAttributes[2];

        saveImage( $imageFileName, $imageOriginalFileName, $imageCaption, $contentObjectAttribute );
        $contentObjectAttributes[2]->store();

        include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
        $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                 'version' => 1 ) );
        $contentObject->setAttribute('modified', $imageCreatedTime );
        $contentObject->setAttribute('published', $imageCreatedTime );
        $contentObject->store();
    }
}

function saveImage( $imageFileName, $originalImageFileName, $caption, &$contentObjectAttribute )
{
    include_once( "lib/ezutils/classes/ezdir.php" );
    $contentObjectAttributeID = $contentObjectAttribute->attribute( "id" );
    $version = $contentObjectAttribute->attribute( "version" );

    include_once( "kernel/common/image.php" );
    $image =& eZImage::create( $contentObjectAttributeID , $version );

    $image->setAttribute( "contentobject_attribute_id", $contentObjectAttributeID );
    $image->setAttribute( "version", $version );
    $image->setAttribute( "filename", $imageFileName );
    $image->setAttribute( "original_filename", $originalImageFileName );

    $mimeObj = new eZMimeType();
    $mime = $mimeObj->mimeTypeFor( false, $originalImageFileName );
    $image->setAttribute( "mime_type", $mime );
    $image->setAttribute( "alternative_text", $caption );
    $image->store();

    $sys =& eZSys::instance();
    $storage_dir = $sys->storageDirectory();

    $ori_dir = $storage_dir . '/' . "original/image";
    $ref_dir = $storage_dir . '/' . "reference/image";
    if ( !file_exists( $ori_dir ) )
    {
        eZDir::mkdir( $ori_dir, 0777, true);
    }
    if ( !file_exists( $ref_dir ) )
    {
        eZDir::mkdir( $ref_dir, 0777, true);
    }

    $source_file = $storage_dir . "/catalogue/" . $imageFileName;
    $target_file = $storage_dir . "/original/image/" . $imageFileName;
    $reference_file = $storage_dir . "/reference/image/" . $imageFileName;
    copy($source_file, $target_file );

//    copy($source_file, $reference_file );

    include_once( "kernel/common/image.php" );
    include_once( "lib/ezutils/classes/ezini.php" );
    $img =& imageInit();
    $convertedName = $imageFileName;
    $imgINI =& eZINI::instance( 'image.ini' );
    $ruleList = $imgINI->variableArray( 'Rules', 'Rules' );
    foreach ( $ruleList as $items )
    {
        $sourceMIME = $items[0];
        $destMIME = $items[1];
        $type = $items[2];
        if ( $type == 'convert' or
             $type == 'gd' )
        {
            $sourceMIME = str_replace("image/", "", $sourceMIME );
            $destMIME = str_replace("image/", "", $destMIME );
            $convertedName = str_replace( $sourceMIME, $destMIME, $convertedName );
        }
    }
    $reference_dir = $storage_dir . "/reference/image/";
    $destFilename = preg_replace('/\.(.*)$/', "", $imageFileName) ;
    $ini =& eZINI::instance();
    $width = $ini->variable( "ImageSettings" , "ReferenceSizeWidth" );
    $height = $ini->variable( "ImageSettings" , "ReferenceSizeHeight" );
    $refImagename = $img->convert( $target_file,
                                   $reference_dir . $destFilename,
                                   array( "width" => $width, "height" => $height ),
                                   false
                                   );
}
?>
