#!/usr/bin/php
<?php
set_time_limit( 0 );

print( "Starting URL translation\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );
include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

include_once( 'kernel/classes/ezcontentobject.php' );

include_once( 'kernel/classes/ezurlalias.php' );

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
}

global $articlePrefix;
$articlePrefix = "article_article_";
print( "Article Prefix: " . $articlePrefix . "\n" );

$importedArticleList =& getAllImportedArticles();

foreach ( $importedArticleList as $article )
{
    translateURL( $article );
}

function &getAllImportedArticles()
{
    global $articlePrefix;
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$articleArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id, ezcontentobject.id, ezcontentobject.remote_id
                                      FROM ezcontentobject, ezcontentobject_tree
	                                  WHERE ezcontentobject.remote_id like '$articlePrefix%'
                                        AND ezcontentobject.id = ezcontentobject_tree.contentobject_id
                                        AND ezcontentobject_tree.main_node_id = ezcontentobject_tree.node_id
                                      ORDER BY ezcontentobject.id ASC" );
	return $articleArray;
}

function translateURL( &$article )
{
    global $articlePrefix;
    $nodeID = $article['node_id'];
    $remoteID = $article['remote_id'];
    $oldArticleID = str_replace( $articlePrefix, "",  $remoteID );
    $source = "article/articleview/$oldArticleID";
    $destination = "content/view/full/$nodeID";
    $alias = new eZURLAlias( array() );
    $alias->setAttribute( 'source_url', $source );
    $alias->setAttribute( 'destination_url', $destination );
    $alias->setAttribute( 'is_internal', false );
    $alias->store();
}

print( "URL translation finished!\n" );
?>
