#!/usr/bin/php
<?php

set_time_limit( 0 );

print( "Starting file import\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );

include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

global $databasePrefix;
$databasePrefix = "";

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
}

$fileList =& fileList();
foreach ( $fileList as $file )
{
    addFile( $file );
}

function &fileList()
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$fileArray = $db->arrayQuery( "SELECT *
	FROM
	  eZFileManager_File
    ORDER BY ID" );
	return $fileArray;
}

function addFile( &$file )
{
    global $databasePrefix;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	//fetch file class
	$class =& eZContentClass::fetch( 12 );

    unset( $contentObject );
    $fileID = $file['ID'];
    $fileName = $file['Name'];
    $fileDescription = $file['Description'];
    $fileFileName = $file['FileName'];
    $fileOriginalFileName = $file['OriginalFileName'];
    $fileUserID = $file['UserID'];

    if ( $databasePrefix != "" )
    {
        $remoteUserID = $databasePrefix . "_" . "user_" . $fileUserID;
        $remoteID = $databasePrefix . "_" . "file_" . $fileID;
        $remoteParentIDPrefix =  $databasePrefix . "_";
        $unassignedFileFolderID = $databasePrefix . "_" . "file_unassigned_folder";
    }
    else
    {
        $remoteUserID =  "user_" . $fileUserID;
        $remoteID = "file_" . $fileID;
        $remoteParentIDPrefix = "";
        $unassignedFileFolderID = "file_unassigned_folder";
    }
    $remoteParentNodeArray = $db->arrayQuery( "SELECT * from eZFileManager_FileFolderLink WHERE FileID = '$fileID'" );

    $assignedNodes = array();
    if ( $remoteParentNodeArray != null )
    {
        // Find all parent node
        foreach ( $remoteParentNodeArray as $remoteParentNode )
        {
            $remoteParentID = $remoteParentIDPrefix . "file_category_" . $remoteParentNode['FolderID'];
            // Find parent node id
            $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id FROM ezcontentobject, ezcontentobject_tree
                                                   WHERE ezcontentobject.remote_id = '$remoteParentID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );
            $parentNodeID = $parentNodeIDArray[0]['node_id'];
            $assignedNodes[] = $parentNodeID;
        }
    }
    else
    {
        // For those unassigned files, import to main file folder.
        $parentNodeIDArray = $db->arrayQuery( "SELECT ezcontentobject_tree.node_id FROM ezcontentobject, ezcontentobject_tree
                                               WHERE ezcontentobject.remote_id = '$unassignedFileFolderID' AND ezcontentobject.id = ezcontentobject_tree.contentobject_id" );
        $parentNodeID = $parentNodeIDArray[0]['node_id'];
        $assignedNodes[] = $parentNodeID;
    }

    // Find current user id
    $userIDArray = $db->arrayQuery( "SELECT id FROM ezcontentobject WHERE remote_id = '$remoteUserID'" );

    $userID = $userIDArray[0]['id'];

    // If no exist user, set it to administrator.
    if ( $userID == null )
        $userID = 14;

    if ( $userID != null )
    {
        // Create object by user id in section 1
        $contentObject =& $class->instantiate( $userID, 1 );
        $contentObject->setAttribute('remote_id', $remoteID );
        $contentObject->setAttribute( 'name', $fileName );
        foreach ( $assignedNodes as $assignedNode )
        {
            $nodeAssignment =& eZNodeAssignment::create( array(
                                                         'contentobject_id' => $contentObject->attribute( 'id' ),
                                                         'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                         'parent_node' => $assignedNode,
                                                         'sort_field' => 2,
                                                         'sort_order' => 0,
                                                         'is_main' => 1
                                                         )
                                                     );
            $nodeAssignment->store();
        }

        $version =& $contentObject->version( 1 );
        $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        $contentObjectID = $contentObject->attribute( 'id' );
        $contentObjectAttributes =& $version->contentObjectAttributes();

        $contentObjectAttributes[0]->setAttribute( 'data_text', $fileName );
        $contentObjectAttributes[0]->store();

        $inputData = "<?xml version=\"1.0\"?>";
        $inputData .= "<section>";
        $inputData .= "<paragraph>";
        $inputData .= $fileDescription;
        $inputData .= "</paragraph>";
        $inputData .= "</section>";

        include_once( "kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php" );
        $dumpdata = "";
        $simplifiedXMLInput = new eZSimplifiedXMLInput( $dumpdata, null, null );
        $inputData = $simplifiedXMLInput->convertInput( $inputData );
        $description = $inputData[0]->toString();
        $contentObjectAttributes[1]->setAttribute( 'data_text', $description );
        $contentObjectAttributes[1]->store();

        $contentObjectAttribute =& $contentObjectAttributes[2];

        saveFile( $fileFileName, $fileOriginalFileName, $contentObjectAttribute );
        $contentObjectAttributes[2]->store();

        include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
        $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                     'version' => 1 ) );
        $contentObject->store();
    }
}

function saveFile( $fileFileName, $fileOriginalFileName, &$contentObjectAttribute )
{
    include_once( "kernel/classes/datatypes/ezbinaryfile/ezbinaryfile.php" );
    include_once( "lib/ezutils/classes/ezmimetype.php" );
    include_once( "lib/ezutils/classes/ezdir.php" );
    $contentObjectAttributeID = $contentObjectAttribute->attribute( "id" );
    $version = $contentObjectAttribute->attribute( "version" );

    $file =& eZBinaryFile::create( $contentObjectAttributeID , $version );

    $file->setAttribute( "contentobject_attribute_id", $contentObjectAttributeID );
    $file->setAttribute( "version", $version );
    $file->setAttribute( "filename", $fileFileName );
    $file->setAttribute( "original_filename", $fileOriginalFileName );

    $mimeObj = new eZMimeType();
    $mime = $mimeObj->mimeTypeFor( false, $fileOriginalFileName );
    $file->setAttribute( "mime_type", $mime );
    $file->store();

    $sys =& eZSys::instance();
    $storage_dir = $sys->storageDirectory();

    list( $subdir, $extension )= split ("/", $mime );

    $file_dir = $storage_dir . '/' . "original/" . $subdir;

    if ( !file_exists( $file_dir ) )
    {
        eZDir::mkdir( $file_dir, 0777, true);
    }

    $source_file = $storage_dir . "/files/$fileFileName";
    $target_file = $storage_dir . "/original/" . $subdir . "/$fileFileName";
    copy($source_file, $target_file );
}
?>
