#!/usr/bin/php
<?php

set_time_limit( 0 );

print( "Starting User import\n" );
include_once( "lib/ezutils/classes/ezdebug.php" );

include_once( 'lib/ezlocale/classes/ezdatetime.php' );

include_once( "lib/ezutils/classes/ezmodule.php" );
eZModule::setGlobalPathList( array( "kernel" ) );
include_once( 'lib/ezutils/classes/ezexecution.php' );

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );

eZDebug::setHandleType( EZ_HANDLE_TO_PHP );
eZDebug::setLogFileEnabled( false );
eZINI::setIsCacheEnabled( false );

function eZDBCleanup()
{
    if ( class_exists( 'ezdb' )
         and eZDB::hasInstance() )
    {
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
    }
}

function eZFatalError()
{
    eZDebug::setHandleType( EZ_HANDLE_NONE );
    print( "Fatal error: eZ publish did not finish it's request\n" );
    print( "The execution of eZ publish was abruptly ended." );
}

eZExecution::addCleanupHandler( 'eZDBCleanup' );
eZExecution::addFatalErrorHandler( 'eZFatalError' );

$ini =& eZINI::instance();

$server = $ini->variable( 'DatabaseSettings', 'Server' );
$user = $ini->variable( 'DatabaseSettings', 'User' );
$pwd = $ini->variable( 'DatabaseSettings', 'Password' );
$dbb = $ini->variable( 'DatabaseSettings', 'Database' );

print( "$server $user $pwd $dbb\n" );
eZExecution::cleanup();
eZExecution::setCleanExit();

$databasePrefix = "";

if ( count( $_SERVER['argv'] ) > 1 )
{
    $databasePrefix = $_SERVER['argv'][1];
}

global $userPrefix;
global $userGroupPrefix;

if ( $databasePrefix != "" )
{
    $userPrefix = $databasePrefix . "_" . "user_";
    $userGroupPrefix = $databasePrefix . "_" . "user_group_";
}
else
{
    $userPrefix = "user_";
    $userGroupPrefix = "user_group_";
}
print( "User Prefix: " . $userPrefix . "\n" );
print( "User Group Prefix: " . $userGroupPrefix . "\n" );

$userGroupList =& userGroupList( );
foreach ( $userGroupList as $userGroup )
{
    $groupID = $userGroup['ID'];
    $groupName = $userGroup['Name'];
    $groupDescription = $userGroup['Description'];
    $importCaption = $userGroupPrefix . $groupID;
    $newGroupNodeID = createUserGroup( $groupName, $groupDescription, $importCaption, $parentNodeID = 5 );
    importUser( $groupID, $newGroupNodeID );
}

function &userGroupList( )
{
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
	$groupArray = $db->arrayQuery( "SELECT *
	FROM
	  eZUser_Group
    ORDER BY ID" );
	return $groupArray;
}

function createUserGroup( $name, $description, $importCaption, $parentNodeID = 5 )
{
    $groupNodeID = 5;
    $db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	//fetch folder class
	$class =& eZContentClass::fetch( 3 );

    unset( $contentObject );
    $userID = 14;

    // Check if the user group has already been added.
    $db =& eZDB::instance();
    $db->setIsSQLOutputEnabled( false );
    $result = $db->arrayQuery( "SELECT * from ezcontentobject WHERE remote_id = '$importCaption'" ) ;
    if ( count( $result ) < 1 )
    {
        // Create object by user id in section 1
        $contentObject =& $class->instantiate( $userID, 1 );
        $contentObject->setAttribute( 'remote_id', $importCaption );
        $contentObject->setAttribute( 'name', $name );
        $nodeAssignment =& eZNodeAssignment::create( array(
                                                         'contentobject_id' => $contentObject->attribute( 'id' ),
                                                         'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                         'parent_node' => $parentNodeID,
                                                         'sort_field' => 7,
                                                         'sort_order' => 1,
                                                         'is_main' => 1
                                                         )
                                                     );
        $nodeAssignment->store();

        $version =& $contentObject->version( 1 );

        $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        $contentObjectID = $contentObject->attribute( 'id' );
        $contentObjectAttributes =& $version->contentObjectAttributes();

        $contentObjectAttributes[0]->setAttribute( 'data_text', $name );
        $contentObjectAttributes[0]->store();

        $contentObjectAttributes[1]->setAttribute( 'data_text', $description );
        $contentObjectAttributes[1]->store();

        include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
        $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                     'version' => 1 ) );

        $contentObject->setAttribute('section_id', 2 );
        $contentObject->store();
         // Get node id for this folder
        $nodeIDArray = $db->arrayQuery( "SELECT node_id FROM ezcontentobject_tree
                                         WHERE contentobject_id = '$contentObjectID' AND contentobject_version = 1" );
        $groupNodeID = $nodeIDArray[0]['node_id'];
    }
    return $groupNodeID;
}

function importUser( $oldGroupID, $newGroupID )
{
    $allUser =& allGroupUser( $oldGroupID );

    addAllGroupUser( $allUser, $newGroupID );
}

function &allGroupUser( $groupID )
{
	$db =& eZDB::instance();
	$db->setIsSQLOutputEnabled( false );
	$userArray = $db->arrayQuery( "SELECT DISTINCT eZUser_User.*
	FROM
	   eZUser_User,
	   eZUser_Group,
	   eZUser_UserGroupLink
	WHERE
	   eZUser_User.ID = eZUser_UserGroupLink.UserID
	   AND
	   eZUser_Group.ID = eZUser_UserGroupLink.GroupID
	   AND
	   eZUser_Group.ID = $groupID" );
	return $userArray;
}

function addAllGroupUser( $existUsers, $groupID )
{
	//fetch user class
	$class =& eZContentClass::fetch( 4 );
    global $userPrefix;
	foreach( $existUsers as $existUser )
	{
		unset( $contentObject );

		$login = $existUser['Login'];
		$email = $existUser['Email'];
		$password_hash = $existUser['Password'];
		$firstName = $existUser['FirstName'];
		$lastName = $existUser['LastName'];
        $remoteID = $userPrefix . $existUser['ID'];

        // Check if the user has already been added.
        $db =& eZDB::instance();
        $db->setIsSQLOutputEnabled( false );
        $result = $db->arrayQuery( "SELECT * from ezcontentobject WHERE remote_id = '$remoteID'" ) ;

        if ( count( $result ) < 1 )
        {
            // Create object by user 14 in section 1
            $contentObject =& $class->instantiate( 14, 1 );
            $contentObject->setAttribute('remote_id', $remoteID );
            $contentObject->store();
        }
        else
        {
            $contentObjID = $result[0]['id'];
            $contentObject =& eZContentObject::fetch( $contentObjID );
        }

        if ( count( $result ) < 1 )
        {
            $nodeAssignment =& eZNodeAssignment::create( array(
                                                             'contentobject_id' => $contentObject->attribute( 'id' ),
                                                             'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                             'parent_node' => $groupID,
                                                             'is_main' => 1
                                                             )
                                                         );
        }
        else
        {
            $nodeAssignment =& eZNodeAssignment::create( array(
                                                             'contentobject_id' => $contentObject->attribute( 'id' ),
                                                             'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                             'parent_node' => $groupID,
                                                             'is_main' => 0
                                                             )
                                                         );
        }
        $nodeAssignment->store();

        $version =& $contentObject->version( 1 );
        $version->setAttribute( 'modified', eZDateTime::currentTimeStamp() );
        $version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT );
        $version->store();

        $contentObjectID = $contentObject->attribute( 'id' );
        $contentObjectAttributes =& $version->contentObjectAttributes();

        $contentObjectAttributes[0]->setAttribute( 'data_text', $firstName );
        $contentObjectAttributes[0]->store();

        $contentObjectAttributes[1]->setAttribute( 'data_text', $lastName );
        $contentObjectAttributes[1]->store();

        $user =& eZUser::create( $contentObjectID );
        $user->setAttribute('login', $login );
        $user->setAttribute('email', $email);
        $user->setAttribute('password_hash', $password_hash );
        $user->setAttribute('password_hash_type', 4 );
        $user->store();

        include_once( 'lib/ezutils/classes/ezoperationhandler.php' );
        $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $contentObjectID,
                                                                                     'version' => 1 ) );
    }
}
?>
