<?php
//

/*
                //log dir
                $logdirpath="/home/web/download.ezpublishhosting.com/html/ezirc/logs/";
                $currentLog="IQ-current.log";
                $yesterdayLog="IQ-yesterday.log";
                $newLog="IQ-new.log";

		// ini_set('auto_append_file', "$logdirpath$currentLog");
*/


class IQBot {
	// bind(): attach a user function to an event
	// $type: type of event, "join, part, quit, pub, pubm, etc." Read documentation.
	// $flags: flags required to have by the user
	// $target: used only for channels, regexp friendly
	// $function: user function to call
	function bind($type,$flags,$target,$trigger,$function) {
		$this->binds[$type][]=array(
			'flags' => $flags,
			'target' => $target,
			'trigger' => $trigger,
			'function' => $function
		);
	}
	
	// execbind(): process binds of $type
	function execbind($type,$args=array()) {
		if (!$this->binds[$type]) {
			//$this->debug("No bind type '$type'");
			return;
		}
		else {
			//$this->debug("execing bind $type");
		}
		
		// go through each bind of $type
		foreach($this->binds[$type] as $foo) {
			// if the bind has a target, check $args's target, if no match, skip this bind
			if ($foo["target"]) {
				if (!eregi($foo["target"],$args["target"])) {
					continue;
				}
			}
			
			if ($foo["trigger"]) {
				// builds array of possible trigger prefixes
				$_trigs=array();
				$_trigs[]=$this->info["prefix"];
				if ($this->config["nickasprefix"]) {
					$_trigs[]="^".$this->info["mynick"].": ";
					$_trigs[]="^".$this->info["mynick"].", ";
					$_trigs[]="^".$this->info["mynick"]."; ";
					// If msg is private, do not require a prefix
					if ($args["isprivmsg"] && $this->config["privnoprefix"]) {
						$_trigs[]="^";
					}
				}
				// cycle through array and check for match
				unset($matched_prefix);
				foreach ($_trigs as $_trig) {
					$trig_temp=str_replace("<trig_prefix>",$_trig,str_replace("<prefix>",$_trig,$foo["trigger"])); // possible trigger
					if (eregi($trig_temp,$args["msg"])) {
						$matched_prefix=$_trig;
					}
				}
				// if no trigger matched, skip this bind
				if (!isset($matched_prefix)) {
					//$this->log($foo["trigger"]);
					continue; 
				}
				else {
					$args["matched_prefix"]=$matched_prefix;
					if (strpos($matched_prefix," ") && $args["extmsg"]) {
						// the matched prefix contains spaces, must adjust extmsg
						$num_spaces=strlen($matched_prefix)-strlen(str_replace(" ","",$matched_prefix));
						$split=split(" ",$args["extmsg"]);
						for ($i=1;$i<=$num_spaces;$i++) {
							array_shift($split);
						}
						$args["extmsg"]=join(" ",$split);
					}
				}
			}
			
			// see if the user has the flags to match this bind
			if ($this->checkflags($foo["flags"],$args["flags"])) {
				if (function_exists($this->functions[$foo["function"]])) {
					$this->functions[$foo["function"]]($args);
				}
				else {
					$this->problemLog("User function '{$foo["function"]}' does not exist");
				}
			}
		}
	}
	
	// rehash(): reload modules, themes, and bot configuration
	function rehash() {
		$this->modules=array();
		$this->binds=array();
		$this->users=array();
		$this->objects=array();

		// Load standard themes file
		if (!include("include/themes.php")) {
			die("Could not load themes.php.\n");
		}		

		if (!include($this->info["configfile"])) {
			$this->problemLog("Error loading configuration file {$this->info["configfile"]}");
			die();
		}
		
		// Load themes from themes/ directory
		if (is_dir("themes")) {
			if ($dh=opendir($dir)) {
				while ($file=$readdir($dh)) {
					if (ereg("\.theme\.",$file)) {
						include($file);
					}
				}
				closedir($dh);
			}
		}
		
		// Correct the trigger prefix
		$prefix=$this->config["prefix"];
		/* escape certain characters that would confuse the regex */
		foreach (array("\\",".","|","(",")","[","]","{","}","?","*","^","$","-","+",",") as $foo) {
			$prefix=str_replace($foo,"\\".$foo,$prefix);
		}
		$prefix="^$prefix"; // make it a true prefix (must begin the line)
		$this->info["prefix"]=$prefix;

		// Put channels into an array
		$this->info["my_channels"]=split(" ",ereg_replace(" +"," ",strtolower($this->config["chans"])));
		
		// Make channel names all lowercase in keys array
		if ($this->config["keys"]) {
			foreach ($this->config["keys"] as $key => $value) {
				unset($this->config["keys"][$key]);
				$this->config["keys"][strtolower($key)]=$value;
			}
		}			
		
		// Match up bot's channels to the channels the bot is in, and join/part accordingly
		if ($this->info["in_channels"] && $this->conn) {
			foreach ($this->info["in_channels"] as $_chan) {
				if (!in_array($_chan,$this->info["my_channels"])) {
					$this->raw("PART $_chan");
				}
			}		
			
			foreach ($this->info["my_channels"] as $_chan) {
				if (!in_array($_chan,$this->info["in_channels"])) {
					$this->raw("JOIN $_chan {$this->config["keys"][$_chan]}");
				}
			}
		}
		
		$this->log(ctext("-- Configuration loaded.","white"));
	}
	
	// saveConfig(): freezes current running configuration to $file
	function saveConfig($file="") {
		$file=$file ? $file : $this->info["configfile"];
		
		$config=array(); // work with $config
		if ($oldconfig=@file($file)) { // load entire config file into an array
			$oldexists=true;
			// strip all but code from $config
			foreach(array_keys($oldconfig) as $key) {
				if (ereg("^.this->config\[",$oldconfig[$key])) {
					$var=trim(substr($oldconfig[$key],0,strpos($oldconfig[$key],"=")));
					$value=trim(substr($oldconfig[$key],strpos($oldconfig[$key],"=")+1));
					$value=substr($value,0,-1); // remove semicolon
					if (substr($value,0,1)=="\"" && substr($value,-1)=="\"") {
						$value=substr($value,1,-1);
					}
					//$this->debug("'$var' is '$value'");
					$config[strtolower($var)]=array("line" => $key, "value" => $value);
				}
				$oldconfig[$key]=trim($oldconfig[$key]);
			}
		}
		
		/* at this point, $config is set to values from $file (if any) */
		
		// do replacements to $config for keys
		foreach(array_keys($this->config) as $key) {
			if (!is_array($this->config[$key])) {
				$config["\$this->config[\"$key\"]"]["value"]=$this->config[$key];
			}
			else {
				foreach(array_keys($this->config[$key]) as $foo) {
					$config["\$this->config[\"$key\"][\"$foo\"]"]["value"]=$this->config[$key][$foo];
				}
			}
		}
		// save channels
		$config["\$this->config[\"chans\"]"]["value"]=join(" ",$this->info["my_channels"]);
		
		// Manually merge $oldconfig and $config
		foreach (array_keys($config) as $key) {
			$quote=(!is_numeric($config[$key]["value"])) ? "\"" : "";
			$str="$key = $quote".$config[$key]["value"]."$quote;";
			if (!$config[$key]["line"]) {
				$temp=$oldconfig[count($oldconfig)-1];
				$tempplace=count($oldconfig)-1;
				$oldconfig[]=$temp;
				$oldconfig[$tempplace]=$str;
			}
			else {
				$oldconfig[$config[$key]["line"]]=$str;
			}
		}
		
		// Heh, $oldconfig is now the new config to be written to file
		$fp=fopen($file,"w");
		if (!$fp) {
			$this->problemLog("Could not open $file for writing");
			return 0;
		}
		else {
			if (!$oldexists) { fputs($fp,"<?php\n"); }
			fputs($fp,join("\n",$oldconfig));
			if (!$oldexists) { fputs($fp,"\n?>"); }
			fclose($fp);
			$this->infoLog("Saved config to $file.");
			return 1;
		}				
	}
	
	// Output a line formatted to an entry in a themes file
	// $input is an array of arguments
	function themeize($type,$input) {
		$use_theme=($this->themes[$this->config["theme"]][$type]) ? $this->config["theme"] : "default";
		$style=$this->themes[$use_theme][$type];

		$return=$style;
		for ($i=0;$i<=count($input)-1;$i++) {
			$return=str_replace("%".($i+1),$input[$i],$return);
		}
		
		return $return;
	}
	
	function loadmodule($modfile) {
		if (!file_exists($modfile)) {
			return;
		}
		$exec=trim(shell_exec("php -l $modfile"));
		if (!ereg("No syntax errors",$exec)) {
			$msg="Compile error. Did not load $modfile. ($exec)";
			$this->problemLog($msg);
			return $msg;
		}
		else {
			require($modfile);
			$this->modules[]=$modfile;
			return 0;
		}
	}
	
	function adduser($username,$hostmask,$flags) {
		// so $hostmask won't break preg_match
		$hostmask=str_replace("/","\/",$hostmask);
		$hostmask=str_replace("[","\[",$hostmask);
		$hostmask=str_replace("]","\]",$hostmask);
		$hostmask=str_replace("{","\{",$hostmask);
		$hostmask=str_replace("}","\}",$hostmask);
		// wildcards
		$hostmask=str_replace(".","\.",$hostmask);
		$hostmask=str_replace("#","[0-9]",$hostmask);
		$hostmask=str_replace("*",".*?",$hostmask);
		$hostmask=str_replace("&","[a-z]",$hostmask);
		$hostmask=str_replace("%",".",$hostmask);
		$hostmask=str_replace(".*?+",".*?",$hostmask);
		$hostmask=str_replace("..*?",".*?",$hostmask);
				
		$this->debug("Adding $username ($hostmask) with flags \"$flags\"");
		$this->users[]=array(
			"username" => $username,
			"hostmask" => $hostmask,
			"flags" => $flags
		);
	}	
	
	function getflags($hostmask) {
		foreach ($this->users as $user) {
			foreach (split(" ",$user["hostmask"]) as $foo) {
				if (preg_match("/$foo/i",$hostmask)) {
					return $user["flags"];
				}
			}
		}
	}
	
	function checkflags($funcflags,$userflags) {
		for ($i=0;$i<strlen($funcflags);$i++) {
			$flag=substr($funcflags,$i,1);
			if (!ereg($flag,$userflags)) {
				return 0;
			}
		}
		return 1;
	}
	
	function getrank($chan,$nick) {
		$usermodes=$this->info["channel_users"][$chan][$nick]["modes"];
		$output="";
		foreach ($this->info["chan_user_modes"] as $mode=>$prefix) {
			if ($usermodes[$mode]) {
				$output.=$prefix;
			}
		}
		return $output;
	}
	
	function connect($server,$port) {
		return @fsockopen($server,$port,$errstr,$errno,10);
	}
	
	function raw($text="",$buffer=true) {
		if (!$buffer) {
			// don't buffer, send right now
			fputs($this->conn,$text."\r\n");
			$this->debug("raw >> $text");
		}
		else {
			if ($text) {
				$this->debug("queuing: $text");
				$this->send_queue[]=$text;
			}
			if (count($this->send_queue)) {
				if (!$this->replyto("send_queue",1) || !$this->buffering) {
					$this->rawFlush();
				}
				else {
					//$this->debug("can't flush right now, waiting.");
				}
			}
		}
	}
	
	function rawFlush() {
		$lines=1; // lines to send at a time
		$i=0;
		foreach ($this->send_queue as $foo) {
			$i++;
			if ($foo) {
				fputs($this->conn,"$foo\r\n");
				if ($this->config["debug"]==1) {
					$this->debug("raw >> ".$foo);
				}
				
			}
			array_shift($this->send_queue);
			if ($i==$lines) {
				return;
			}
		}
	}
	
	/* Logging functions */
	
	function log($text,$timestamp=true) {
		global $daemon;
		// do nothing if $text is just whitespace or nothing
		if (!trim($text)) { return; }
		
		if (!$daemon) {
			echo ($timestamp) ? "[".date("H:i:s")."] " : "";
			echo ereg_replace(chr(3)."[0-9]{1,2},?[0-9]?","",trim($text))."\n";
		}

                /////////////////////////		
                // log dir

                $logdirpath="/home/web/download.ezpublishhosting.com/html/ezirc/logs/";
		$currentLog="ezpublish.log";
		$yesterdayLog="ezpublish-yesterday.log";
		$newLog="ezpublish-new.log";

		if ($this->config["log"]) {
			// write to logfile
			$logstr=preg_replace("/".chr(27)."\[[0-9;m]+(.*?)".chr(27)."\[0m/i","\$1",$text);
			// set log date if necessary
			$this->log["date"]=($this->log["date"]) ? $this->log["date"] : date("Y-m-d");
			// rotate logs if necessary

			if (date("Y-m-d") != $this->log["date"] && file_exists("$logdirpath$currentLog")) {
				$this->debug("Rotating log files");
				if ($this->log["handle"]) {
					fclose($this->log["handle"]);
					unset($this->log["handle"]);
				}
				if (!rename("$logdirpath$currentLog","$logdirpath$yesterdayLog")) {
					die("Could not rotate log files. Check permissions.\n");
				}
			}
			if (!$this->log["handle"]) {
				$this->log["date"]=date("Y-m-d");
				if (!($this->log["handle"]=@fopen("$logdirpath$currentLog","a"))) {
					die("Could not open log file. Check permissions.\n");
				}
			}
			fputs($this->log["handle"],"[".date("m-d-Y H:i:s")."] $logstr\n");
		}
	}
	
	// other logging functions
	function infoLog($text,$timestamp=true) {
		$this->log($this->themeize("info",array($text)),$timestamp);
	}
	
	function problemLog($text,$timestamp=true) {
		$this->log($this->themeize("problem",array($text)),$timestamp);
	}
	
	function debug($text) {
		if ($text && $this->config["debug"]==1) {
			echo "[".date("H:i:s")."] (debug) ".trim($text)."\n";
		}
	}
	
	// this function is designed to buffer responses
	// so the bot will not flood
	//
	// will return 0 if $sec or greater has passed
	// since $msgtype was last sent
	// or 1 if not.
	function replyto($msgtype,$sec=5) {
		if (!$this->replyto[$msgtype]) {
			$this->replyto[$msgtype]=time();
			$return=0;
		}
		elseif (time()-$this->replyto[$msgtype] >= $sec) {
			$this->replyto[$msgtype]=time();
			$return=0;
		}
		else {
			$return=1;
		}
		//$this->debug("replyto ($msgtype,$sec): $return");
		return $return;
	}
	
	/* IRC commands */
	
	// action(): send an action to a channel
	function action($target,$action,$verbose=1,$buffer=true) {
		$this->msg($target,chr(1)."ACTION $action".chr(1),$verbose,$buffer);
	}
	
	// ctcp(): send client to client protocol message of $type (ex: PING) to $target with text $text.
	function ctcp($target,$type,$text,$verbose=1,$buffer=true) {
		$this->msg($target,chr(1)."$type $text".chr(1),$verbose,$buffer);
	}
	
	// ctcpreply(): send client to client protocol reply
	function ctcpreply($target,$type,$text,$verbose=1,$buffer=true) {
		$this->notice($target,chr(1)."$type $text".chr(1),$verbose,$buffer);
	}

	// join(): join a channel (with keys from internal key list)
	function join($target,$buffer=true) {
		$target=strtolower($target);
		$key=($bot->config["keys"][$target]) ? $bot->config["keys"][$foo] : "x";
		$this->raw("JOIN $target :$key",$buffer);
	}
	
	// mode(): set $modes on $target
	function mode($target,$modes,$buffer=true) {
		$_modes=gettok($modes,0);
		$_args=etc(split(" ",$modes),1);
		$this->raw("MODE $target $_modes $_args",$buffer);
	}	

	// msg(): send IRC message of $text to $target 
	function msg($target,$text,$verbose=1,$buffer=true) {
		$target=strtolower($target);
		$text=split("\n",$text);
		foreach ($text as $line) {
			if ($line) {
				$this->raw("PRIVMSG $target :$line",$buffer);
				if ($verbose) {
					$priv_append=(substr($target,0,1) == "#") ? "chan_" : "priv_";
					$this->log($this->themeize("self_".$priv_append."msg",array($target,$this->info["mynick"],$line)));
				}
			}
		}
	}
	
	// notice(): send IRC notice of $text to $target
	function notice($target,$text,$verbose=1,$buffer=true) {
		$target=strtolower($target);
		$text = split("\n",$text);
		foreach ($text as $line) {
			if ($line) {
				$this->raw("NOTICE $target :$line",$buffer);
				if ($verbose) {
					$priv_append=(substr($target,0,1) == "#") ? "chan_" : "priv_";
					$this->log($this->themeize("self_".$priv_append."notice",array($target,$this->info["mynick"],$line)));
				}
			}
		}
	}

	// part(): part a channel
	function part($target,$reason="",$buffer=true) {
		$this->raw("PART $target :$reason",$buffer);
	}
	
	/* handling code for events */
	
	function handleRaw($raw,$in="") {
		if (method_exists($this,"raw$raw")) {
			$this->{"raw".$raw}($in);
		}
		elseif ($in) {
			// array of numerics to ignore for various reasons
			$ignore=array(
				"002", // welcome information
				"003", // welcome information
				"253", // unknown connections
				"301", // away message
				"311", // whois info, host line
				"312", // server tag
				"313", // is an IRC operator
				"315", // end of /who list
				"317", // idletime in whois
				"318", // end of whois
				"319", // whois for channels
				"353", // names
				"366", // end of /names list
				"372", // MOTD
				"375", // MOTD
				"376", // end of /motd command
				"422", // MOTD file missing
			);
			
			if (!in_array($raw,$ignore)) {
				$this->log("(unmatched::raw$raw) $in");
			}
		}
		
		// Execute raw binds
		$this->execbind("raw",array("target" => $raw,"in" => $in));
	}
	
	function handleEvent($event,$in="") {
		if (method_exists($this,"event$event")) {
			$this->{"event$event"}($in);
		}
	}
	
	/* Raws */
	
	// 001: welcome message
	function raw001($in) {
		$this->info["mynick"]=gettok($in,2);
		unset($this->info["tried_altnick"]);
		unset($this->info["nick_suffix"]);
		$this->replyto("getnick",180); // prevent bot from trying to get its nick back immediately
		$this->buffering=1; // turn on buffering by default
	}
	
	// 004: Mode options
	function raw004($in) {
		$this->info["user_modes"]=gettok($in,5);
		$this->info["channel_modes"]=gettok($in,6);
		// Hack. The IRC protocol doesn't specify modes with arguments to be sent, so.. guess!
		$this->info["modes_with_args"]=(gettok($in,7)) ? gettok($in,7) : "bDefIlkohv";
		$this->debug("Found modes with args: ".gettok($in,7));
		// at this point the bot has all information that it really needs
		$this->info["registered"]=1;
		$this->infoLog("Successfully registered. Nick is: {$this->info["mynick"]}");
		$this->execbind("register");
	}
	
	// 005: server information
	function raw005($in) {
		$trimmed=etc(split(" ",$in),3);
		list($trimmed,$garbage)=split(" :",$trimmed);
		$split=split(" ",$trimmed);
		foreach ($split as $foo) {
			list($var,$value)=split("=",$foo);
			$this->serverinfo[strtolower($var)]=$value;
		}			
		if ($this->serverinfo["network"]) {
			$this->info["server"]=substr(gettok($in,0),1);
			if (!$GLOBALS["daemon"]) {
				set_titlebar("IQ {$this->version}{$this->extraversion}: {$this->info["mynick"]} connected to ".substr(gettok($in,0),1)." ({$this->serverinfo["network"]})");
			}
		}
		if ($this->serverinfo["prefix"]) {
			$foo=substr($this->serverinfo["prefix"],1);
			list($modes,$prefixes)=split(")",$foo);
			for($i=0;$i<=strlen($modes)-1;$i++) {
				$mode=substr($modes,$i,1);
				$this->info["chan_user_modes"][$mode]=substr($prefixes,$i,1);
			}
		}
	}
	
	// 250: lusers
	function raw250($in) {
		$in_arr=split(" ",$in);
		$str=substr(etc($in_arr,3),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 251: lusers
	function raw251($in) {
		$in_arr=split(" ",$in);
		$str=substr(etc($in_arr,3),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 252: lusers
	function raw252($in) {
		$in_arr=split(" ",$in);
		$str=$in_arr[3]." ".substr(etc($in_arr,4),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 254: lusers	
	function raw254($in) {
		$in_arr=split(" ",$in);
		$str=$in_arr[3]." ".substr(etc($in_arr,4),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 255: lusers
	function raw255($in) {
		$in_arr=split(" ",$in);
		$str=substr(etc($in_arr,3),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 265: lusers
	function raw265($in) {
		$in_arr=split(" ",$in);
		$str=substr(etc($in_arr,3),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 266: lusers
	function raw266($in) {
		$in_arr=split(" ",$in);
		$str=substr(etc($in_arr,3),1);
		$this->log($this->themeize("lusers",array($str)));
	}
	
	// 332: topic
	function raw332($in) {
		$in_arr=split(" ",$in);
		$target=strtolower(gettok($in,3));
		$topic=substr(etc($in_arr,4),1);
		$this->info["channel_topics"][$target]["topic"]=$topic;
		$this->log($this->themeize("topic",array($target,$topic)));
	}	

	// 333: topic set by
	function raw333($in) {
		$target=strtolower(gettok($in,3));
		$hostmask=gettok($in,4);
		list($nick,$ident,$host)=parsemask($hostmask);
		$time=gettok($in,5);
		$this->log($this->themeize("topic_setby",array($nick,$ident,$host,date("r",$time))));
	}
	
	// 352: result of /WHO
	function raw352($in) {
		$in_arr=split(" ",$in);
		list($target,$ident,$host,$server,$nick,$status,$hopcount,$realname)=array(
			strtolower(gettok($in,3)),
			gettok($in,4),
			gettok($in,5),
			gettok($in,6),
			gettok($in,7),
			gettok($in,8),
			substr(gettok($in,9),1),
			etc($in_arr,10)
		);
		$target=strtolower($target);
		$modes=array();
		foreach ($this->info["chan_user_modes"] as $mode=>$prefix) {
			if (ereg("\\$prefix",$status)) {
				$modes[$mode]=1;
			}
		}		
		$this->info["channel_users"][$target][$nick]=array(
			"ident" => $ident,
			"host" => $host,
			"server" => $server,
			"realname" => $realname,
			"modes" => $modes
		);
	}
	
	// 353: names listing
	function raw353($in) {
		$in_arr=split(" ",$in);
		$target=strtolower(gettok($in,4));
		$num=count($in_arr)-5;
		$this->info["user_counts"][$target]+=$num;
	}
	
	// 366: end of /NAMES list
	function raw366($in) {
		$target=strtolower(gettok($in,3));
		if ($this->info["user_counts"][$target] <= $this->config["wholimit"]) {
			$this->raw("WHO $target");
		}
	}
	
	// 401: no suck nick/channel
	function raw401($in) {
		$target=strtolower(gettok($in,3));
		$this->problemLog("No suck nick/channel: $target");
	}
	
	// 433: nickname in use
	function raw433($in) {
		if ($this->info["mynick"] != $this->config["altnick"]) {		
			if (!$this->info["tried_altnick"]) {
				$this->info["tried_altnick"]=1;
				$this->problemLog("Primary nickname in use, trying alternate.");
				$this->raw("NICK {$this->config["altnick"]}");
			}
			elseif (!$this->info["mynick"]) {
				$this->problemLog("Alternate nickname also in use, appending numbers to primary nickname. (Sleeping 5 seconds)");
				sleep(5); // so we don't flood off
				$this->info["nick_suffix"]++;
				$this->raw("NICK {$this->config["nickname"]}{$this->info["nick_suffix"]}");
			}
		}
	}
	
	// 464: Password incorrect
	function raw464($in) {
		$this->problemLog("Bad password, disconnecting.");
	}
	
	// 473: cannot join channel (+i)
	function raw473($in) {
		$target=strtolower(gettok($in,3));
		$this->problemLog("Cannot join $target, channel is invite only.");
	}
	
	// 474: cannot join channel (+b)
	function raw474($in) {
		$target=strtolower(gettok($in,3));
		$this->problemLog("Cannot join $target, address is banned.");
	}
	
	// 475: cannot join channel (+k)
	function raw475($in) {
		$target=strtolower(gettok($in,3));
		$this->problemLog("Cannot join $target, incorrect key.");
	}
	
	// 482: not a channel operator
	function raw482($in) {
		$target=strtolower(gettok($in,3));
		$this->problemLog("Not a channel operator on $target.");
	}

	/* Events */
	
	function eventInvite($in) {
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$target=strtolower(substr(gettok($in,3),1));
		$flags=$this->getflags($hostmask);
		$inick=gettok($in,2);
		$this->infoLog("$inick invited to $target by $nick");
		
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"flags" => $flags,
			"target" => $target
		);
		
		// Join if invited to a channel the bot is supposed to be in, but is not		
		if ($inick==$this->info["mynick"] && in_array(strtolower($target),$this->info["my_channels"]) && !in_array(strtolower($target),$this->info["in_channels"])) {
			$this->raw("JOIN $target",false);
		}
		
		$this->execbind("invite",$args);
	}

	function eventJoin($in) {
		$target=strtolower(str_replace(":","",gettok($in,2)));
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$flags=$this->getflags($hostmask);
		$this->log($this->themeize("join",array($nick,$ident,$host,$target)));
		
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"target" => $target,
			"flags" => $flags,
		);
		
		$this->execbind("join",$args);
		
		if ($nick==$this->info["mynick"]) {
			$this->info["in_channels"][]=$target;
			$this->info["user_counts"][$target]=0;
			if (!in_array($target,$this->info["my_channels"])) {
				$this->info["my_channels"][]=$target;
			}
		}
		else {
			$this->info["user_counts"][$target]++;
		}
		$this->info["channel_users"][$target][$nick]["ident"]=$ident;
		$this->info["channel_users"][$target][$nick]["host"]=$host;
	}
	
	function eventKick($in) {
		$in_arr=split(" ",$in);
		$target=strtolower(gettok($in,2));
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$knick=gettok($in,3);
		$msg=trim(substr(etc($in_arr,4),1));
		$flags=$this->getflags($hostmask);
		$this->log($this->themeize("kick",array($knick,$target,$nick,$msg)));
			
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"knick" => $knick,
			"flags" => $flags,
			"target" => $target,
			"msg" => $msg
		);
		
		$this->info["channel_users"][$target][$nick]["ident"]=$ident;
		$this->info["channel_users"][$target][$nick]["host"]=$host;
		
		$this->execbind("kick",$args);
				
		if ($knick==$this->info["mynick"]) {
			// bot was kicked from channel
			$chan_key=array_search($target,$this->info["in_channels"]);
			unset($this->info["in_channels"][$chan_key]);
			unset($this->info["channel_users"][$target]);
			$this->raw("JOIN $target");
		}
		else {
			unset($this->info["channel_users"][$target][$knick]);
		}
	}
	
	function eventMode($in) {
		$in_arr=split(" ",$in);
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$modes=(substr(etc($in_arr,3),0,1) != ":") ? etc($in_arr,3) : substr(etc($in_arr,3),1);
		$target=strtolower(gettok($in,2));
		$flags=$this->getflags($hostmask);
		$this->log($this->themeize("mode",array($nick,$modes,$target)));
				
		$watch="";
		$remmodes=array();
		$addmodes=array();
		$modeflags=gettok($modes,0);
		$i=1;
		
		for ($x=0;$x<=strlen($modeflags)-1;$x++) {
			$mode=substr($modeflags,$x,1);
			
			if ($mode=="-") {
				$watch="remmodes";
			}
			elseif ($mode=="+") {
				$watch="addmodes";
			}
			elseif ($watch) {
				if (ereg($mode,$this->info["modes_with_args"])) { // confirm $mode requires arguments
					// the limit mode is fucked up. Who designed this damn protocol?
					if ($mode=="l" && $watch=="remmodes") {
						array_push(${$watch},array($mode => ""));
						$this->debug("pushed to $watch: $mode");
					}
					else {
						array_push(${$watch},array($mode => gettok($modes,$i)));
						$this->debug("pushed to $watch: $mode => ".gettok($modes,$i));
						$i++;
					}
				}
				else { // mode is not known to have arguments
					array_push(${$watch},array($mode => ""));
					$this->debug("pushed to $watch: $mode");
				}								
			}
		}

		//print_r($addmodes);
		//print_r($remmodes);
		
		if (substr($target,0,1) == "#") {
			foreach ($addmodes as $foo) {
				foreach (array_keys($foo) as $foomode) {
					// $foomode is the mode set (v,o,k,l, etc)
					// $foo[$foomode] will return the arg (who is opped, voiced, the key, the limit, etc)
					if (in_array($foomode,array_keys($this->info["chan_user_modes"]))) {
						$this->info["channel_users"][$target][$foo[$foomode]]["modes"][$foomode]=1;
					}
					if ($foomode == "k") {
						$this->config["keys"][$target]=$foo[$foomode];
					}
				}
			}

			foreach ($remmodes as $foo) {
				foreach (array_keys($foo) as $foomode) {
					if (in_array($foomode,array_keys($this->info["chan_user_modes"]))) {
						unset($this->info["channel_users"][$target][$foo[$foomode]]["modes"][$foomode]);
					}
					if ($foomode == "k") {
						unset($this->config["keys"][$target]);
					}
				}
			}
		}
			
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"nick" => $nick,
			"flags" => $flags,
			"target" => $target,						
			"modes" => $modes,
			"addmodes" => $addmodes,
			"remmodes" => $remmodes,
		);

		$this->info["channel_users"][$target][$nick]["ident"]=$ident;
		$this->info["channel_users"][$target][$nick]["host"]=$host;		
		
		$this->execbind("mode",$args);
	}
	
	function eventNick($in) {
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$newnick=substr(gettok($in,2),1);
		$flags=$this->getflags($hostmask);
		$this->log($this->themeize("nick",array($nick,$newnick)));
		
		$args=array(
			"nick" => $nick,
			"newnick" => $newnick,
			"ident" => $ident,
			"host" => $host,
			"flags" => $flags,						
		);
			
		$this->execbind("nick",$args);
		
		if ($nick==$this->info["mynick"]) {
			$this->info["mynick"]=$newnick;
			$this->log("My new nick is $newnick");
		}
		
		foreach (array_keys($this->info["channel_users"]) as $foochan) {
			if ($this->info["channel_users"][$nick]) {
				$this->info["channel_users"][$newnick]=$this->info["channel_users"][$nick];
				unset($this->info["channel_users"][$nick]);
			}
		}
	}
	
	function eventNotice($in) {
		$in_arr=split(" ",$in);
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$target=strtolower(gettok($in,2));
		if ($target==$this->info["mynick"]) {
			$isPrivmsg=true;
			$target=$nick;
		}
		$msg=substr(etc($in_arr,3),1);
		$extmsg=etc($in_arr,4);
		$flags=$this->getflags($hostmask);
		$priv_append=(!$isPrivmsg) ? "chan_" : "priv_";
		$status=$this->getrank($target,$nick);
		
		$this->log($this->themeize($priv_append."notice",array($target,"$status$nick",$ident,$host,$msg)));
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"target" => $target,
			"flags" => $flags,
			"msg" => $msg,
			"extmsg" => $extmsg,
			"isprivmsg" => $isPrivmsg,
		);
		$this->info["args"]=$args;
		
		$this->execbind("notice",$args);
	}
	
	function eventPart($in) {
		$in_arr=split(" ",$in);
		$target=strtolower(gettok($in,2));
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$flags=$this->getflags($hostmask);
		$msg = substr(etc($in_arr,3),1);
		$this->log($this->themeize("part",array($nick,$ident,$host,$target,$msg)));

		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"target" => $target,
			"flags" => $flags,
			"msg" => $msg
		);
		
		if ($nick==$this->info["mynick"]) {
			$chan_key=array_search($target,$this->info["in_channels"]);
			unset($this->info["in_channels"][$chan_key]);
			$chan_key=array_search($target,$this->info["my_channels"]);
			unset($this->info["my_channels"][$chan_key]);
			unset($this->info["channel_users"][$target]);
			unset($this->info["user_counts"][$target]);
		}
		else {
			unset($this->info["channel_users"][$target][$nick]);
		}
				
		$this->execbind("part",$args);
	}
	
	function eventPrivmsg($in) {
		$in_arr=split(" ",$in);
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$target=strtolower(gettok($in,2));
		if ($target==strtolower($this->info["mynick"])) {
			$isPrivmsg=true;
			$target=$nick;
		}
		$msg=substr(etc($in_arr,3),1);
		$extmsg=etc($in_arr,4);
		$flags=$this->getflags($hostmask);
		$priv_append=(!$isPrivmsg) ? "chan_" : "priv_";
		$status=$this->getrank($target,$nick);
		$ctcp="";
				
		if (substr($msg,0,7)==chr(1)."ACTION" && substr($msg,-1)==chr(1)) {
			$action=1;
			$msg=substr($msg,8,-1);
			$this->log($this->themeize($priv_append."action",array($target,"$status$nick",$ident,$host,$msg)));
		}
		elseif (substr($msg,0,1)==chr(1) && substr($msg,-1)==chr(1)) {
			$foo=split(" ",substr($msg,1,-1));
			$ctcp=$foo[0];
			$msg=etc($foo,1);
			$extmsg=etc($foo,2);
			if ($ctcp != "LAG") {
				$this->log($this->themeize($priv_append."ctcp",array($target,"$status$nick",$ident,$host,$ctcp,$msg)));
			}
		}
		else {
			$this->log($this->themeize($priv_append."msg",array($target,"$status$nick",$ident,$host,$msg)));
		}
		
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"target" => $target,
			"flags" => $flags,
			"ctcp" => $ctcp,
			"action" => $action,
			"msg" => $msg,
			"extmsg" => $extmsg,
			"isprivmsg" => $isPrivmsg,
		);
		$this->info["args"]=$args;
				
		// Lag!
		if ($ctcp=="LAG") {
			$now=microtime();
			$lag=(gettok($now,0)+gettok($now,1)) - (gettok($msg,0)+gettok($msg,1)); // lag in seconds
			$lag=round($lag,3); // lag in s.uuu
			$this->info["lagcheck_reply"]=$msg;
			$this->info["lag"]=$lag;
		}
			
		// respond to CTCP VERSION
		if ($ctcp=="VERSION" && !$this->replyto("ctcpversion",2)) {
			$this->ctcpreply($nick,"VERSION","IQ {$this->version}{$this->extraversion}");
		}
				
		// respond to CTCP PING
		if ($ctcp=="PING" && !$this->replyto("ctcpping",1)) {
			$this->ctcpreply($nick,"PING",$msg);
		}
		
		$this->info["channel_users"][$target][$nick]["ident"]=$ident;
		$this->info["channel_users"][$target][$nick]["host"]=$host;
					
		$this->execbind("pubm",$args);
		if (!$isPrivmsg) {
			$this->execbind("pub",$args);
		}
		else {
			$this->execbind("msg",$args);
		}
	}
	
	function eventQuit($in) {
		$in_arr=split(" ",$in);
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$msg=substr(etc($in_arr,2),1);
		$flags=$this->getflags($hostmask);
		$this->log($this->themeize("quit",array($nick,$ident,$host,$msg)));
		
		$args=array(
			"nick" => $nick,
			"ident" => $ident,
			"host" => $host,
			"nick" => $nick,
			"flags" => $flags,						
			"msg" => $quitmsg
		);					
				
		$this->execbind("quit",$args);
		
		if ($nick==$this->config["nickname"] && $this->info["mynick"]!=$this->config["nickname"]) {
			// gain back nickname
			$this->raw("NICK {$this->config["nickname"]}");
		}
				
		// remove nick from channel_users array
		foreach (array_keys($this->info["channel_users"]) as $foochan) {
			unset($this->info["channel_users"][$foochan][$nick]);
			$this->info["user_counts"][$foochan]--;
		}
	}
	
	function eventTopic($in) {
		$in_arr=split(" ",$in);
		$hostmask=substr(gettok($in,0),1);
		list($nick,$ident,$host)=parsemask($hostmask);
		$newtopic=substr(etc($in_arr,3),1);
		$flags=$this->getflags($hostmask);
		$target=strtolower(gettok($in,2));
		$this->log($this->themeize("topic_change",array($nick,$target,$newtopic)));
			
		$args=array(
			"nick" => $nick,
			"topic" => $newtopic,
			"ident" => $ident,
			"host" => $host,
			"flags" => $flags,
			"target" => $target,
		);
				
		$this->execbind("topic",$args);
		
		$this->info["channel_users"][$target][$nick]["ident"]=$ident;
		$this->info["channel_users"][$target][$nick]["host"]=$host;
	}
}
?>
