<?php
//
// Created on: <04-Jul-2002 13:06:30 bf>
//
// Copyright (C) 1999-2005 eZ systems as. All rights reserved.
//
// This source file is part of the eZ publish (tm) Open Source Content
// Management System.
//
// This file may be distributed and/or modified under the terms of the
// "GNU General Public License" version 2 as published by the Free
// Software Foundation and appearing in the file LICENSE included in
// the packaging of this file.
//
// Licencees holding a valid "eZ publish professional licence" version 2
// may use this file in accordance with the "eZ publish professional licence"
// version 2 Agreement provided with the Software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
// THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE.
//
// The "eZ publish professional licence" version 2 is available at
// http://ez.no/ez_publish/licences/professional/ and in the file
// PROFESSIONAL_LICENCE included in the packaging of this file.
// For pricing of this licence please contact us via e-mail to licence@ez.no.
// Further contact information is available at http://ez.no/company/contact/.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// Contact licence@ez.no if any conditions of this licencing isn't clear to
// you.
//
//
// This is almost entirely cut-n-pasted code from content/action with 
// a lot of stuff removed and one small section added by Nathan Sharp

include_once( 'kernel/classes/ezcontentobject.php' );
include_once( 'kernel/classes/ezcontentobjecttreenode.php' );
include_once( 'kernel/classes/ezcontentbrowse.php' );
include_once( 'kernel/classes/ezcontentbrowsebookmark.php' );
include_once( 'kernel/classes/ezcontentclass.php' );
include_once( "lib/ezutils/classes/ezhttptool.php" );
include_once( 'ezobjectcreator.php' );

$http =& eZHTTPTool::instance();
$module =& $Params["Module"];

if ( $http->hasPostVariable( 'NewButton' ) )
{
    $hasClassInformation = false;
    $contentClassID = false;
    $contentClassIdentifier = false;
    $class = false;
    if ( $http->hasPostVariable( 'ClassID' ) )
    {
        $contentClassID = $http->postVariable( 'ClassID' );
        if ( $contentClassID )
            $hasClassInformation = true;
    }
    else if ( $http->hasPostVariable( 'ClassIdentifier' ) )
    {
        $contentClassIdentifier = $http->postVariable( 'ClassIdentifier' );
        $class =& eZContentClass::fetchByIdentifier( $contentClassIdentifier );
        if ( is_object( $class ) )
        {
            $contentClassID = $class->attribute( 'id' );
            if ( $contentClassID )
                $hasClassInformation = true;
        }
    }
    if ( $hasClassInformation && $http->hasPostVariable( 'NodeID' ) ) 
    {
        $node =& eZContentObjectTreeNode::fetch( $http->postVariable( 'NodeID' ) );

        if ( is_object( $node ) )
        {
            $parentContentObject =& $node->attribute( 'object' );
            if ( $parentContentObject->checkAccess( 'create', $contentClassID,  $parentContentObject->attribute( 'contentclass_id' ) ) == '1' )
            {
                $user =& eZUser::currentUser();
                $userID =& $user->attribute( 'contentobject_id' );
                $sectionID = $parentContentObject->attribute( 'section_id' );

                if ( !is_object( $class ) )
                    $class =& eZContentClass::fetch( $contentClassID );
                if ( is_object( $class ) )
                {
                    $contentObject =& $class->instantiate( $userID, $sectionID );
                    $nodeAssignment =& eZNodeAssignment::create( array(
                                                                     'contentobject_id' => $contentObject->attribute( 'id' ),
                                                                     'contentobject_version' => $contentObject->attribute( 'current_version' ),
                                                                     'parent_node' => $node->attribute( 'node_id' ),
                                                                     'is_main' => 1
                                                                     )
                                                                 );
                    if ( $http->hasPostVariable( 'AssignmentRemoteID' ) )
                    {
                        $nodeAssignment->setAttribute( 'remote_id', $http->postVariable( 'AssignmentRemoteID' ) );
                    }
                    $nodeAssignment->store();

                    if ( $http->hasPostVariable( 'RedirectURIAfterPublish' ) )
                    {
                        $http->setSessionVariable( 'RedirectURIAfterPublish', $http->postVariable( 'RedirectURIAfterPublish' ) );
                    }
                    
                    //NPS: -----------------------------------
                    //Create default values if found.
                    $post_vars =& $http->attribute('post');
                    $obj_creator =& new eZObjectCreator();
                    // Set status to draft for the content object version
                    $content_object_version =& $contentObject->version(
                          $contentObject->attribute( 'current_version' ) );
                    $content_object_version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT);
                    $content_object_version->store();            
                    // Assign the attributes
                    $content_attributes =& $content_object_version->contentObjectAttributes();
                    
                    foreach( $content_attributes as $content_attribute )
                    {
                       // Each attribute has an attribute called 'identifier' that identifies it.
                       $attribute_identifier = 
                          $content_attribute->attribute("contentclass_attribute_identifier");
                       $post_key = "default_".$attribute_identifier;
                       if ( $http->hasPostVariable($post_key)) 
                       {
                          $post_val = $http->postVariable($post_key);
                          $obj_creator->importAttribute($post_val, $content_attribute);
                       }
                    }
                    //NPS: -------------------------------
                    
                    $module->redirectTo( 'content/edit/' . $contentObject->attribute( 'id' ) . '/' . $contentObject->attribute( 'current_version' ) );
                    return;
                }
                else
                {
                    return $module->handleError( EZ_ERROR_KERNEL_ACCESS_DENIED, 'kernel' );
                }
            }
            else
            {
                return $module->handleError( EZ_ERROR_KERNEL_ACCESS_DENIED, 'kernel' );
            }
        }
        else
        {
            return $module->handleError( EZ_ERROR_KERNEL_NOT_AVAILABLE, 'kernel' );
        }
    }
    else if ( $hasClassInformation )
    {
        if ( !is_object( $class ) )
            $class =& eZContentClass::fetch( $contentClassID );
        eZContentBrowse::browse( array( 'action_name' => 'NewObjectAddNodeAssignment',
                                        'description_template' => 'design:content/browse_first_placement.tpl',
                                        'keys' => array( 'class' => $class->attribute( 'id' ),
                                                         'classgroup' => $class->attribute( 'ingroup_id_list' ) ),
                                        'persistent_data' => array( 'ClassID' => $class->attribute( 'id' ) ),
                                        'content' => array( 'class_id' => $class->attribute( 'id' ) ),
                                        'cancel_page' => $module->redirectionURIForModule( $module, 'view', array( 'full', 2 ) ),
                                        'from_page' => "/content/action" ),
                                 $module );
    }
}


// return module contents
$Result = array();
$Result['content'] =& $result;

?>
