<?php
//
// Created on: <24-Apr-2005>
//
// Copyright (C) 2005 Nathan Sharp. All rights reserved.
//
// This file may be distributed and/or modified under the terms of the
// "GNU General Public License" version 2 as published by the Free
// Software Foundation and appearing in the file LICENSE included in
// the packaging of this file.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
// THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE.
//
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// This file is a derivative work of many code bits from www.ez.no
//

include_once( 'kernel/classes/ezcontentobjecttreenode.php' );
include_once( "lib/ezutils/classes/ezdebug.php" );
include_once( "lib/ezutils/classes/ezoperationhandler.php" );

/**
 * Simple Object Creation.  I used this to import data from
 * other php systems. 
 *
 * Most limiting aspect is that it doesn't handle all data types yet.
 * See the select statement in importAttribute for what is supported.
 */
class eZObjectCreator
{

   function eZObjectCreator()
   {
   }
   
   /**
    * creates and publishes an object.
    * @param parent_node_id - The parent node to publish under.
    * @param owner_id - The user id to be the creator of the new object.
    * @param class_name - The class name of the class to instantiate (such as image)
    * @param attributes - A hashtable of attributename => attributevalue pairs.
    */
   function createObject($parent_node_id, $owner_id, $class_name, $attributes)
   {
      $class =& eZContentClass::fetchByIdentifier( $class_name );
      if ( !is_object( $class ) )
      {
         die("Real error stuff here1");
      }
      $parent_node =& eZContentObjectTreeNode::fetch($parent_node_id);
      // set associated object to parent node (folder object) 
      if ( !is_object( $parent_node ) )
      {
         die("Real error stuff here2");
      }
      //Create the object
      $parent_content = $parent_node->attribute('object');
      $section_id = $parent_content->attribute( 'section_id' );
      $content_object =& $class->instantiate( $owner_id, $section_id );
      
      //assign new object to parent node
      $node_assignment =& eZNodeAssignment::create( array(
            'contentobject_id' => $content_object->attribute( 'id' ),
            'contentobject_version' => $content_object->attribute( 'current_version' ),
            'parent_node' => $parent_node->attribute( 'node_id' ),
            'is_main' => 1 ) );
      $node_assignment->store();
      
      // Set status to draft for the content object version
      $content_object_version =& $content_object->version(
            $content_object->attribute( 'current_version' ) );
      $content_object_version->setAttribute( 'status', EZ_VERSION_STATUS_DRAFT);
      $content_object_version->store();

      // Assign the attributes
      $content_attributes =& $content_object_version->contentObjectAttributes();
      foreach ($content_attributes as $content_attribute)
      {
         // Each attribute has an attribute called 'identifier' that identifies it.
         $attribute_identifier = 
            $content_attribute->attribute("contentclass_attribute_identifier");
         if (isset($attributes[$attribute_identifier]))
         {
            $this->importAttribute($attributes[$attribute_identifier], $content_attribute);
         }
         else
         {
            eZDebug::writeDebug( 'attribute value not found for '.
                  $class_name.".".$attribute_identifier);
         }
      }
      //NPS: Would prefer to warn if attribute passed in to function 
      //that wasn't used.

      //publish the newly created node
      $operation_result = 
         eZOperationHandler::execute( 'content', 'publish', 
               array( 'object_id' => $content_object->attribute( 'id' ),
                      'version' => $content_object->attribute( 'current_version' ) ) );
      eZDebug::writeDebug( 'execute content publish: '.$operation_result['status'], 'importXMLData' ); 
      
      $id = $content_object->attribute('id');
      
      return eZContentObject::fetch($id);
   }
        
        /**
	 * Imports a value to an attribute adapting it to the proper type.
	 * Not written by me, downloaded from ez.no! Extended it only!
	 * @param data The value (string/int/float).
	 * @param contentObjectAttribute The attribute to modify.
	 */
	function importAttribute( $data, &$contentObjectAttribute )
	{
		$contentClassAttribute = $contentObjectAttribute->attribute( 'contentclass_attribute' );
		$dataTypeString = $contentClassAttribute->attribute( 'data_type_string' );
		
		ezDebug::writeDebug( "Converting " . $data . " to expected " . $dataTypeString );
		
		switch( $dataTypeString )
		{
		case 'ezfloat' :
		case 'ezprice' :
			$contentObjectAttribute->SetAttribute( 'data_float', $data );
			$contentObjectAttribute->store();
			break;
		case 'ezboolean' :
		case 'ezinteger' :
		case 'ezsubtreesubscription' :
                case 'ezobjectrelation' : //NPS: Doesn't handle fuzzy match
		case 'eztime' :
			$contentObjectAttribute->SetAttribute( 'data_int', $data );
			$contentObjectAttribute->store();
			break;
		case 'ezdate' :
		case 'ezdatetime' :
                        if ( ! is_numeric($data) )
                        {
                           $data = strtotime($data);
                        }
                        error_log("date is ".$data,0);
			$contentObjectAttribute->SetAttribute( 'data_int', $data );
			$contentObjectAttribute->store();
			break;
		case 'ezemail' :
		case 'ezisbn' :
		case 'ezstring' :
		case 'eztext' :
		case 'ezurl' :
			$contentObjectAttribute->SetAttribute( 'data_text', $data );
			$contentObjectAttribute->store();
			break;
		case 'ezxmltext' :
			$dummy = "";
			$converter = new text2xml( $dummy, 0, $contentObjectAttribute );
			$converter->validateText( $data, $contentObjectAttribute );
			$contentObjectAttribute->SetAttribute( 'data_int', EZ_XMLTEXT_VERSION_TIMESTAMP );
			$contentObjectAttribute->store();
			break;
		case 'ezimage':
			$this->SaveImage( $data, $contentObjectAttribute );
			break;
		case 'ezbinaryfile':
			$this->SaveFile( $data, $contentObjectAttribute );
			break;		
		case 'ezenum':
			//removed enum - function can be found at ez.no	
		default :
			die( 'Can not store ' . $data . ' as datatype: ' . $dataTypeString );
		}
	}

   /**
   * Instantiates the eZImage class and assignes it to the attribute passed.
   * Not written by me, downloaded from ez.no!
   * @param fileName File's name.
   * @param contentObjectAttribute The attribute to modify.
   */
   function saveImage( $file_name, &$content_object_attribute )
   {
      $content =& $content_object_attribute->content();
      // $content is now an instance of eZImageAliasHandler
      if ( is_object( $content ) )
      {
         $content->initializeFromFile( $file_name );
         if ( $content->isStorageRequired() )
         {
            $content->store();
         }
         else
         {
            die( 'Can not store image '.$file_name );
         }
      }
      else
      {
         die( 'Can not store image, content object attribute appears wrong' );
      }
      return;
   }

	/**
	 * Instantiates the eZBinary class and assignes it to the attribute passed.
	 * @param fileName File's name.
	 * @param contentObjectAttribute The attribute to modify.
	 * @todo Set mime-type correctly
	 */
	function saveFile( $fileName, &$contentObjectAttribute )
	{
		//get info from contentObjectAttribute
		$contentObjectAttributeID = $contentObjectAttribute->attribute( "id" );
		$version = $contentObjectAttribute->attribute( "version" );
	
		//create the new ezImage
		$file =& eZBinaryFile::create( $contentObjectAttributeID , $version );
		
		$file->setAttribute( "contentobject_attribute_id", $contentObjectAttributeID );
		$file->setAttribute( "version", $version );
		$file->setAttribute( "filename", $fileName );
		$file->setAttribute( "original_filename", $fileName );
		
		/*
		//set alterative texts
		$mimeObj = new eZMimeType();
		$mime = $mimeObj->mimeTypeFor( false, $fileName );
		$file->setAttribute( "mime_type", $mime );
		$file->setAttribute( "alternative_text", $fileName );
		*/
		
		$file->store();
	
		//make dir to copy to
		$ori_dir = $this->DIRECTORY_STORAGE . '/' . "original/binary/";
		//$ref_dir = $storage_dir . '/' . "reference/binary/";
		if ( !file_exists( $ori_dir ) )
		{
			eZDir::mkdir( $ori_dir, 0777, true);
		}/*
		if ( !file_exists( $ref_dir ) )
		{
			eZDir::mkdir( $ref_dir, 0777, true);
		}*/
	
		//copy to storage
		$source_file = $this->DIRECTORY_INCOMING . $fileName;
		$target_file = $ori_dir . $fileName;
		//$reference_file = $storage_dir . "/reference/binary/" . $fileName;
		eZDebug::writeDebug( 'copy from ' . $source_file . ' to ' . $target_file );
		copy($source_file, $target_file );
	}
}

        
//
// Created on: <17-Mar-2004 10:11:03 bf>
//
// 1999-2004 eZ systems  1999-2004 - All rights reserved.
//
// Not written by me, copied from ez.no
include_once( 'kernel/classes/datatypes/ezxmltext/handlers/input/ezsimplifiedxmlinput.php' );

class text2xml extends eZSimplifiedXMLInput
{
    function text2xml( &$xmlData, $contentObjectAttribute )
    {
        $this->eZSimplifiedXMLInput( $xmlData, 0, $contentObjectAttribute );
    }

	function &validateText( &$data, &$contentObjectAttribute )
    {
        $contentObjectAttributeID = $contentObjectAttribute->attribute( "id" );
        // Below is same as in the function validateInput(...) in class eZSimplifiedXMLInput
        eZDebug::writeDebug($data, "input data");
        // Set original input to a global variable
        $originalInput = "originalInput_" . $contentObjectAttributeID;
        $GLOBALS[$originalInput] = $data;

        // Set input valid true to a global variable
        $isInputValid = "isInputValid_" . $contentObjectAttributeID;
        $GLOBALS[$isInputValid] = true;

		//replace all special characters with entities
		$this->replaceEntities( $data );
		eZDebug::writeDebug($data, "entitied input data");

        $inputData = "<section xmlns:image='http://ez.no/namespaces/ezpublish3/image/' 
                                xmlns:xhtml='http://ez.no/namespaces/ezpublish3/xhtml/' >";
        $inputData .= "<paragraph>";
        $inputData .= $data;
        $inputData .= "</paragraph>";
        $inputData .= "</section>";

        $data =& $this->convertInput( $inputData );
        $message = $data[1];
        if ( $this->IsInputValid == false )
        {
            $GLOBALS[$isInputValid] = false;
            $errorMessage = null;
            foreach ( $message as $line )
            {
                $errorMessage .= $line .";";
            }
            $contentObjectAttribute->setValidationError( ezi18n( 'kernel/classes/datatypes',
                                                                 $errorMessage,
                                                                 'ezXMLTextType' ) );
            return EZ_INPUT_VALIDATOR_STATE_INVALID;
        }
        else
        {
            $dom = $data[0];
            $objects =& $dom->elementsByName( 'object' );
            if ( $objects !== null )
            {
                foreach ( array_keys( $objects ) as $objectKey )
                {
                    $object =& $objects[$objectKey];
                    $objectID = $object->attributeValue( 'id' );
                    $currentObject =& eZContentObject::fetch( $objectID );
                    $editVersion = $contentObjectAttribute->attribute('version');
                    $editObjectID = $contentObjectAttribute->attribute('contentobject_id');
                    $editObject =& eZContentObject::fetch( $editObjectID );
                    if ( $currentObject == null )
                    {
                        $GLOBALS[$isInputValid] = false;
                        $contentObjectAttribute->setValidationError( ezi18n( 'kernel/classes/datatypes',
                                'Object '. $objectID .' does not exist.', 'ezXMLTextType' ) );
                        return EZ_INPUT_VALIDATOR_STATE_INVALID;
                    }
                    else
                    {
                        $relatedObjects =& $editObject->relatedContentObjectArray( $editVersion );
                        $relatedObjectIDArray = array();
                        foreach ( $relatedObjects as $relatedObject )
                        {
                            $relatedObjectID = $relatedObject->attribute( 'id' );
                            $relatedObjectIDArray[] = $relatedObjectID;
                        }
                        if ( !in_array( $objectID, $relatedObjectIDArray ) )
                        {
                            $editObject->addContentObjectRelation( $objectID, $editVersion );
                        }
                    }

                    // If there are any image object with links.
                    $href = $object->attributeValueNS( 'ezurl_href',
                                'http://ez.no/namespaces/ezpublish3/image/' );
                    $urlID = $object->attributeValueNS( 'ezurl_id', 
                                'http://ez.no/namespaces/ezpublish3/image/' );

                    if ( $href != null )
                    {
                        $linkID =& eZURL::registerURL( $href );
                        $object->appendAttribute( $dom->createAttributeNodeNS(
                                'http://ez.no/namespaces/ezpublish3/image/', 'image:ezurl_id', $linkID ) );
                        $object->removeNamedAttribute( 'ezurl_href' );
                    }

                    if ( $urlID != null )
                    {
                        $url =& eZURL::url( $urlID );
                        if ( $url == null )
                        {
                            $GLOBALS[$isInputValid] = false;
                            $contentObjectAttribute->setValidationError( ezi18n( 'kernel/classes/datatypes',
                                    'Link '. $urlID .' does not exist.', 'ezXMLTextType' ) );
                            return EZ_INPUT_VALIDATOR_STATE_INVALID;
                        }
                    }
                }
            }
            $links =& $dom->elementsByName( 'link' );

            if ( $links !== null )
            {
                foreach ( array_keys( $links ) as $linkKey )
                {
                    $link =& $links[$linkKey];
                    if ( $link->attributeValue( 'id' ) != null )
                    {
                        $linkID = $link->attributeValue( 'id' );
                        $url =& eZURL::url( $linkID );
                        if ( $url == null )
                        {
                            $GLOBALS[$isInputValid] = false;
                            $contentObjectAttribute->setValidationError( ezi18n( 'kernel/classes/datatypes',
                                    'Link '. $linkID .' does not exist.', 'ezXMLTextType' ) );
                            return EZ_INPUT_VALIDATOR_STATE_INVALID;
                        }
                    }
                    if ( $link->attributeValue( 'href' ) != null )
                    {
                        $url = $link->attributeValue( 'href' );
                        $linkID =& eZURL::registerURL( $url );
                        $link->appendAttribute( $dom->createAttributeNode( 'id', $linkID ) );
                        $link->removeNamedAttribute( 'href' );
                    }
                }
            }

            $domString = $dom->toString();

   eZDebug::writeDebug($domString, "unprocessed xml");
   $domString = preg_replace( "#<paragraph> </paragraph>#", "<paragraph> </paragraph>", $domString );
   $domString = str_replace ( "<paragraph />" , "", $domString );
   $domString = str_replace ( "<line />" , "", $domString );
   $domString = str_replace ( "<paragraph></paragraph>" , "", $domString );
   //$domString = preg_replace( "#>[W]+<#", "><", $domString );
   $domString = preg_replace( "#<paragraph> </paragraph>#", "<paragraph />", $domString );
   $domString = preg_replace( "#<paragraph></paragraph>#", "", $domString );

   $domString = preg_replace( "#[\n]+#", "", $domString );
   $domString = preg_replace( "#</LINE>#", "\n", $domString );
   $domString = preg_replace( "#<PARAGRAPH>#", "\n\n", $domString );
   eZDebug::writeDebug($domString, "domstring");
            $xml = new eZXML();
            $tmpDom =& $xml->domTree( $domString, array( 'CharsetConversion' => false ) );
//                 $domString = $tmpDom->toString();
            $domString = eZXMLTextType::domString( $tmpDom );

            eZDebug::writeDebug($domString, "stored xml");
            $contentObjectAttribute->setAttribute( "data_text", $domString );
            $contentObjectAttribute->setValidationLog( $message );

            $paragraphs = $tmpDom->elementsByName( 'paragraph' );

            $classAttribute =& $contentObjectAttribute->contentClassAttribute();
            if ( $classAttribute->attribute( "is_required" ) == true )
            {
                if ( count( $paragraphs ) == 0 )
                    return EZ_INPUT_VALIDATOR_STATE_INVALID;
                else
                    return EZ_INPUT_VALIDATOR_STATE_ACCEPTED;
            }
            else
                return EZ_INPUT_VALIDATOR_STATE_ACCEPTED;
        }
        return EZ_INPUT_VALIDATOR_STATE_INVALID;
    }    
    
	function replaceEntities( &$data )
	{
      $entitiesArray = array(
"&lt;"      =>  "<",
"&gt;"      =>  ">",
"&amp;"     =>  "&",
"&quot;"    =>  "\"",
"&AElig;"   =>  "",
"&Aacute;"  =>  "",
"&Acirc;"   =>  "",
"&Agrave;"  =>  "",
"&Aring;"   =>  "",
"&Atilde;"  =>  "",
"&Auml;"    =>  "",
"&Ccedil;"  =>  "",
"&ETH;"     =>  "",
"&Eacute;"  =>  "",
"&Ecirc;"   =>  "",
"&Egrave;"  =>  "",
"&Euml;"    =>  "",
"&Iacute;"  =>  "",
"&Icirc;"   =>  "",
"&Igrave;"  =>  "",
"&Iuml;"    =>  "",
"&Ntilde;"  =>  "",
"&Oacute;"  =>  "",
"&Ocirc;"   =>  "",
"&Ograve;"  =>  "",
"&Oslash;"  =>  "",
"&Otilde;"  =>  "",
"&Ouml;"    =>  "",
"&THORN;"   =>  "",
"&Uacute;"  =>  "",
"&Ucirc;"   =>  "",
"&Ugrave;"  =>  "",
"&Uuml;"    =>  "",
"&Yacute;"  =>  "",
"&aacute;"  =>  "",
"&acirc;"   =>  "",
"&aelig;"   =>  "",
"&agrave;"  =>  "",
"&aring;"   =>  "",
"&atilde;"  =>  "",
"&auml;"    =>  "",
"&ccedil;"  =>  "",
"&eacute;"  =>  "",
"&ecirc;"   =>  "",
"&egrave;"  =>  "",
"&eth;"     =>  "",
"&euml;"    =>  "",
"&iacute;"  =>  "",
"&icirc;"   =>  "",
"&igrave;"  =>  "",
"&iuml;"    =>  "",
"&ntilde;"  =>  "",
"&oacute;"  =>  "",
"&ocirc;"   =>  "",
"&ograve;"  =>  "",
"&oslash;"  =>  "",
"&otilde;"  =>  "",
"&ouml;"    =>  "",
"&szlig;"   =>  "",
"&thorn;"   =>  "",
"&uacute;"  =>  "",
"&ucirc;"   =>  "",
"&ugrave;"  =>  "",
"&uuml;"    =>  "",
"&yacute;"  =>  "",
"&yuml;"    =>  "",     
  
"&nbsp;"    =>  "",
"&iexcl;"   =>  "",
"&pound;"   =>  "",
"&curren;"  =>  "",
"&yen;"     =>  "",
"&brvbar;"  =>  "",
"&sect;"    =>  "",
"&uml;"     =>  "",
"&copy;"    =>  "",
"&ordf;"    =>  "",
"&laquo;"   =>  "",
"&not;"     =>  "",
"&shy;"     =>  "",
"&reg;"     =>  "",
"&macr;"    =>  "",
"&deg;"     =>  "",
"&plusmn;"  =>  "",
"&sup2;"    =>  "",
"&sup3;"    =>  "",
"&acute;"   =>  "",
"&micro;"   =>  "",
"&para;"    =>  "",
"&middot;"  =>  "",
"&cedil;"   =>  "",
"&sup1;"    =>  "",
"&ordm;"    =>  "",
"&raquo;"   =>  "",
"&frac14;"  =>  "",
"&frac12;"  =>  "",
"&frac34;"  =>  "",
"&iquest;"  =>  "",
  
"&times;"   =>  "",
"&divide;"  =>  "",
"&cent;"    =>  "",
"&apos;"    =>  "'"
);
		
		str_replace( array_values( $entitiesArray ), array_keys( $entitiesArray ), $data );
	}
}        
?>