<?php
//
// Copyright (C) 1999-2004 Vision with Technology, All rights reserved.
//
// This file may be distributed and/or modified under the terms of the
// "GNU General Public License" version 2 as published by the Free
// Software Foundation
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
// THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// Contact licence@visionwt.com if any conditions of this licencing isn't clear to
// you.
//
// Author:       Paul Forsyth
// Version:      $Id:$

define( "SETTING_ENABLED", "enabled" );
define( "SETTING_DISABLED","disabled" );

class eZCMFDeveloper
{
  /*!
   Constructor
  */
  function eZCMFDeveloper()
  {
  }

  function &instance()
  {
    if (isset($GLOBALS[__CLASS__]) && 
        (get_class( $GLOBALS[__CLASS__] ) == __CLASS__))
    {
      $instance = $GLOBALS[__CLASS__];
    }
    else
    {
      $instance = new eZCMFDeveloper();

      $GLOBALS[__CLASS__] =& $this;
    }

    return $instance;
  }

  function isEnabled($iniGroup, $iniSetting)
  {
	$overrideLocal=false;
	if (isset($_COOKIE['ezcmfdeveloper-settings']) && strcmp($_COOKIE['ezcmfdeveloper-settings'], 'override-local')==0)
	{
		$overrideLocal=true;
	}
	
    // Set the command
	$returnValue = $this->setCommand('ezcmfdeveloper-debug', $iniGroup, $iniSetting, $overrideLocal);
	if ($returnValue)
	{
		return $returnValue;
	} 

	$returnValue = $this->setCommand('ezcmfdeveloper-settings', $iniGroup, $iniSetting, $overrideLocal);
	if ($returnValue)
	{
		return $returnValue;
	} 

	$returnValue = $this->setCommand('ezcmfdeveloper-cache', $iniGroup, $iniSetting, $overrideLocal);
	if ($returnValue)
	{
		return $returnValue;
	} 
  }

  function setCommand($cookie, $iniGroup, $iniSetting, $overrideLocal)
  {	
	if (isset($_COOKIE[$cookie]))
    {
		$eZCMFCommand =$_COOKIE[$cookie];
    }
    else
    {
    	return;
    }
  
    $commands=explode("!", $eZCMFCommand);    
    $possibleOverride=false;
    
	foreach ($commands as $command)
	{
	    switch ($iniGroup)
	    {
	      case 'TemplateSettings':
	      {
	        switch($iniSetting)
	        {
	          case 'Debug':
	          {
	            if (strcmp($command, "debug-template")==0)
	            {
	              return(SETTING_ENABLED);
	            }
                else
                {
                  $possibleOverride=true;
                }
	          };
	          break;

	          case 'NodeTreeCaching' :
	          {
	            if (strcmp($command, "no-compile")==0)
	            {
	              $this->unsetAllTemplateCompiling();

	              return(SETTING_ENABLED);
	            }
                else
                {
                  $possibleOverride=true;
                }
	          };
	          break;

	          case 'TemplateCompile':
	          {
	            if (strcmp($command, "no-compile")==0)
	            {
	              $this->unsetAllTemplateCompiling();

	              return(SETTING_ENABLED);
	            }
                else
                {
                  $possibleOverride=true;
                }
	          };
	          break;

	          case 'TemplateCache':
	          {
	            if (strcmp($command, "no-compile")==0)
	            {
	              $this->unsetAllTemplateCompiling();

	              return(SETTING_ENABLED);
	            }
                else
                {
                  $possibleOverride=true;
                }
	          };
	          break;
	        }
		  };
	      break;
	
	      case 'DebugSettings':
	      {
	        switch($iniSetting)
	        {
	          case 'DebugOutput':
	          {
	            if (strcmp($command, "debug-output")==0)
	            {
	              $GLOBALS['eZDebugEnabled']=true;

	              return(SETTING_ENABLED);
	            }
	            elseif ($overrideLocal)
	            {
                  unset($GLOBALS['eZDebugEnabled']);
	            }

                $possibleOverride=true;
	          }
	          break;

	          case 'DebugRedirection':
	          {
		
	            if (strcmp($command, "debug-redirection")==0)
	            {
	              return(SETTING_ENABLED);
	            }
                else
                {
                  $possibleOverride=true;
                }
	          }
	          break;
	        }
	      }

	      case 'DatabaseSettings':
	      {
	        switch($iniSetting)
	        {
	          case 'SQLOutput':
	          {
	            if (strcmp($command, "debug-sql")==0)
	            {
	              return(SETTING_ENABLED);
	            }
                else
                {
                  $possibleOverride=true;
                }
	          }
	          break;
	        }
	      }

	    }
	 }

    // If we have reached here check to see if the override is on
    if ($overrideLocal && $possibleOverride)
    {
      return(SETTING_DISABLED);
    }
  }

  function unsetAllTemplateCompiling()
  {
     // Unsure if this is needed but include anyway	
 	 include_once( 'lib/eztemplate/classes/eztemplatecompiler.php' );
	 eZTemplateCompiler::setSettings( array( 'compile' => false,
                                             'comments' => false,
	                                         'accumulators' => false,
                                             'timingpoints' => false,
                                             'fallbackresource' => false,
                                             'nodeplacement' => true,
                                             'execution' => false,
                                             'generate' => true ) );
  }

  function clearCache()
  {
    // Test if the main cookie has been set
    if (!isset($_COOKIE['ezcmfdeveloper-cache']))
    {
      return(null);
    }

    // Set the command
    $commands=explode("!", $_COOKIE['ezcmfdeveloper-cache']);    
    
    foreach ($commands as $command)
    {
      if (strcmp($command, "clear-cache-always")==0)
      {
        include_once( "kernel/classes/ezcache.php" );
        eZCache::clearAll();
        
        eZDebug::writeNotice("All cache cleared", "eZCMFDeveloper::clearCache");
      }
    }
    
    return null;
  }

}
?>