<?php
//
// $Id: ezqdomrenderer.php 9813 2003-05-07 07:57:23Z br $
//
// Definition of eZQDomRenderer class
//
// Created on: <24-Mar-2001 12:54:26 bf>
//
// This source file is part of eZ publish, publishing software.
//
// Copyright (C) 1999-2001 eZ Systems.  All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, US
//

//!! eZArticle
//! eZQDomRenderer renders XML contents into html articles.
/*!
  This class wil decode the QDom articles generated by eZQDomGenerator.
  Supported tags:
  \code
  <page> - pagebreak
  <header>
  Header text
  </header>
  <link ez.no text to the link> - anchor
  <iconlink ez.no text to the link> - anchor
  <mail adresse@domain.tld subject line, link text> - anchor to email address with subject
  <image 42 align size> - image tag, 42 is the id, alignment (left|center|right|float), size (small|medium|large|original)
  <image 42 align size link> - image tag, 42 is the id, alignment (left|center|right|float), size (small|medium|large|original), the link is optional

  <ezanchor anchorname>

  <module modulename> - this will include a php file named "modulename.php" if it is found in the
  ezrticle/modules dir.

  <bullet>

  </bullet>

  <html>
  html code, this will print out the HTML code..
  </html>

  <cpp>
  cpp code
  </cpp>

  <php>
  php code
  </php>

  <java>
  java code
  </java>

  <ezhtml>
  html code
  </ezhtml>

  <shell>
  shell code
  </shell>

  <sql>
  sql code
  </sql>

  <perl>
  perl code
  </perl>

  <lisp>
  lisp code
  </lisp>

  <bold>
  bold text

  </bold>

  <italic>
  italic text
  </italic>

  <underline>
  underlined text
  </underline>

  <strike>
  strike text
  </strike>

  <pre>
  predefined text
  </pre>

  <verbatim>
  predefined text
  </verbatim>

  <table>
  <tr>
  <td>
  text
  </td>
  </tr>
  </table>
  also
  <table width>
  <table width border>
  <td width>
  <td width colspan>
  <td width colspan rowspan>

  <hr> - horiznontal line

  \endcode
  \sa eZQDomGenerator
*/

/*!TODO
  Add better syntax highlighting.

*/

include_once( "classes/eztexttool.php" );
include_once( "classes/ezlog.php" );
include_once( "ezimagecatalogue/classes/ezimage.php" );
include_once( "ezxml/classes/ezxml.php" );

class eZQDomrenderer
{
    /*!
      Creates a new eZQDomGenerator object.
    */
    function eZQDomrenderer( &$article, $template=false )
    {
        $UsedImageList = array();
        $RollOverCount = 0;

        $ini =& INIFile::globalINI();

        $this->Template = new eZTemplate( "ezarticle/user/" . $ini->read_var( "eZArticleMain", "TemplateDir" ),
                     "ezarticle/user/intl/", "en_GB", "articleview.php" );

        if ( file_exists( "ezarticle/user/" . $ini->read_var( "eZArticleMain", "TemplateDir" ) . "articletags_$template.tpl" ) )
        {
            $this->Template->set_file( "articletags_tpl", "articletags_$template.tpl"  );
        }
        else
        {
            $this->Template->set_file( "articletags_tpl", "articletags.tpl"  );

        }

        $this->Template->set_block( "articletags_tpl", "header_1_tpl", "header_1"  );
        $this->Template->set_block( "articletags_tpl", "header_2_tpl", "header_2"  );
        $this->Template->set_block( "articletags_tpl", "header_3_tpl", "header_3"  );
        $this->Template->set_block( "articletags_tpl", "header_4_tpl", "header_4"  );
        $this->Template->set_block( "articletags_tpl", "header_5_tpl", "header_5"  );
        $this->Template->set_block( "articletags_tpl", "header_6_tpl", "header_6"  );

        $this->Template->set_block( "articletags_tpl", "rollover_tpl", "rollover"  );

        $this->Template->set_block( "articletags_tpl", "image_tpl", "image"  );
        $this->Template->set_block( "articletags_tpl", "media_tpl", "media"  );
        $this->Template->set_block( "articletags_tpl", "file_tpl", "file"  );
        $this->Template->set_block( "image_tpl", "image_link_tpl", "image_link"  );
        $this->Template->set_block( "image_tpl", "ext_link_tpl", "ext_link"  );
        $this->Template->set_block( "image_tpl", "no_link_tpl", "no_link"  );

        $this->Template->set_block( "image_tpl", "image_text_tpl", "image_text"  );

        $this->Template->set_block( "articletags_tpl", "image_float_tpl", "image_float" );
        $this->Template->set_block( "image_float_tpl", "image_link_float_tpl", "image_link_float" );
        $this->Template->set_block( "image_float_tpl", "ext_link_float_tpl", "ext_link_float"  );
        $this->Template->set_block( "image_float_tpl", "no_link_float_tpl", "no_link_float"  );

        $this->Template->set_block( "articletags_tpl", "link_tpl", "link"  );
        $this->Template->set_block( "articletags_tpl", "popuplink_tpl", "popuplink"  );

        $this->Template->set_block( "articletags_tpl", "hr_tpl", "hr"  );

        $this->Template->set_block( "articletags_tpl", "bold_tpl", "bold"  );
        $this->Template->set_block( "articletags_tpl", "italic_tpl", "italic"  );
        $this->Template->set_block( "articletags_tpl", "underline_tpl", "underline"  );
        $this->Template->set_block( "articletags_tpl", "strong_tpl", "strong"  );
        $this->Template->set_block( "articletags_tpl", "strike_tpl", "strike"  );
        $this->Template->set_block( "articletags_tpl", "factbox_tpl", "factbox"  );
        $this->Template->set_block( "articletags_tpl", "quote_tpl", "quote"  );
        $this->Template->set_block( "articletags_tpl", "pre_tpl", "pre"  );
        $this->Template->set_block( "articletags_tpl", "html_tpl", "html"  );

        // lists
        $this->Template->set_block( "articletags_tpl", "bullet_tpl", "bullet"  );
        $this->Template->set_block( "bullet_tpl", "bullet_item_tpl", "bullet_item"  );

        $this->Template->set_block( "articletags_tpl", "list_tpl", "list"  );
        $this->Template->set_block( "list_tpl", "list_item_tpl", "list_item"  );

        // table
        $this->Template->set_block( "articletags_tpl", "table_tpl", "table"  );
        $this->Template->set_block( "table_tpl", "tr_tpl", "tr"  );
        $this->Template->set_block( "tr_tpl", "td_tpl", "td"  );

        // user defined tags
        $customTags = $ini->read_var( "eZArticleMain", "CustomTags" );

        $this->CustomTagsArray = explode( ";", $customTags );

        foreach ( $this->CustomTagsArray as $tag )
        {
            $this->Template->set_block( "articletags_tpl", $tag . "_tpl", "$tag"  );
        }

        // get custom <br> command, needed for other renderes than html
        $this->BrOverride = $this->Template->get_user_variable( "articletags_tpl",  "br" );
		if ( $this->BrOverride="" )
			$this->BrOverride = true; 
			
        $this->Article =& $article;
    }

    /*!
      Returns the XHTML contents of the introduction of the article.
    */
    function &renderIntro()
    {
//        $xml =& xmltree( $this->Article->contents() );
        $xml =& eZXML::domTree( $this->Article->contents() );

        if ( !$xml )
        {
            print( "<br /><b>Error: eZQDomRenderer::docodeXML() could not decode XML</b><br />" );
        }
        else
        {
            $intro = "";

            $articleImages = $this->Article->images();
            $articleID = $this->Article->id();

            $i=0;
            $this->PrevTag = "";
            foreach ( $xml->children as $child )
            {
                if ( $child->name == "article" )
                {
                    foreach ( $child->children as $article )
                    {
                        if ( $article->name == "intro" )
                        {
                            if ( count( $article->children ) > 0 )
                            {
                                foreach ( $article->children as $paragraph )
                                {
                                    $intro .= $this->renderPlain( $paragraph );
                                    $intro .= $this->renderStandards( $paragraph );
                                    $intro .= $this->renderCustom( $paragraph );
                                    $intro .= $this->renderImage( $paragraph );
                                    $intro .= $this->renderHeader( $paragraph );
                                    $intro .= $this->renderMedia( $paragraph );
                                    $intro .= $this->renderFile( $paragraph );
                                    $intro .= $this->renderLink( $paragraph );
                                    $intro .= $this->renderHr( $paragraph );
                                    $intro .= $this->renderTable( $paragraph );
                                    $intro .= $this->renderRollOver( $paragraph );

                                    $this->PrevTag = $paragraph->name;
                                }
                            }
                        }
                    }
                }
            }

//            $newArticle = eZTextTool::nl2br( $intro );
            $newArticle = $intro;
        }

        return $newArticle;
    }

    /*!
      Returns the XHTML article of the article.
    */
    function &renderPage( $pageNumber=0 )
    {
//        $xml =& qdom_tree( $this->Article->contents() );

        $xml =& eZXML::domTree( $this->Article->contents() );

//        $xml =& xmltree( $this->Article->contents() );

//        $err = qdom_error();
//        if ( $err )
//            print( $err );

        if ( !$xml )
        {
            print( "<br /><b>Error: eZQDomRenderer::docodeXML() could not decode XML</b><br />" );
        }
        else
        {
            $intro = "";

            $this->PrevTag = "";
            $articleImages =& $this->Article->images();

            if ( get_class( $this->Article ) == "ezarticle" )
                $articleMedia =& $this->Article->media();

            $articleID = $this->Article->id();

            $body = array();

            foreach ( $xml->children as $child )
            {
                if ( $child->name == "article" )
                {
                    foreach ( $child->children as $article )
                    {
                        if ( $article->name == "intro" )
                        {
                            if ( count( $article->children ) > 0 )
                                foreach ( $article->children as $paragraph )
                                {
                                    $intro .= $this->renderHeader( $paragraph );
                                    $intro .= $this->renderPlain( $paragraph );
                                    $intro .= $this->renderStandards( $paragraph );
                                    $intro .= $this->renderCustom( $paragraph );
                                    $intro .= $this->renderImage( $paragraph );
                                    $intro .= $this->renderMedia( $paragraph );
                                    $intro .= $this->renderFile( $paragraph );
                                    $intro .= $this->renderLink( $paragraph );
                                    $intro .= $this->renderHr( $paragraph );
                                    $intro .= $this->renderTable( $paragraph );
                                    $intro .= $this->renderRollOver( $paragraph );

                                    $this->PrevTag = $paragraph->name;
                                }
                        }

                        if ( $article->name == "body" )
                        {
                            $body = $article->children;
                        }
                    }
                }
            }

            $pageArray = array();
            // loop on the pages
            foreach ( $body as $page )
            {
                if ( $page->name == "page" )
                {
                    $pageContent = "";
                    $this->PrevTag = "";
                    // loop on the contents of the pages
                    if ( isset( $page->children ) && count( $page->children ) > 0 )
						foreach ( $page->children as $paragraph )
						{
							$pageContent .= $this->renderHeader( $paragraph );
							$pageContent .= $this->renderStandards( $paragraph );
							$pageContent .= $this->renderCustom( $paragraph );
							$pageContent .= $this->renderPlain( $paragraph );
							$pageContent .= $this->renderImage( $paragraph );
							$pageContent .= $this->renderMedia( $paragraph );
							$pageContent .= $this->renderFile( $paragraph );
							$pageContent .= $this->renderLink( $paragraph );
							$pageContent .= $this->renderHr( $paragraph );
							$pageContent .= $this->renderTable( $paragraph );
							$pageContent .= $this->renderRollOver( $paragraph );


							$this->PrevTag = $paragraph->name;

						}
                    $pageArray[] = $pageContent;
                }
            }

            $returnArray = array();
            $bodyContents = "";

            if ( $pageNumber == -1 )
            {
                $newArticle = $intro . "\n</p><p>\n";
                if ( count( $pageArray ) > 0 )
                    foreach ( $pageArray as $page )
                    {
                        $bodyContents .= $page;
                    }
            }
            else if ( $pageNumber != 0 )
            {
                $intro = "";
                $bodyContents = $pageArray[$pageNumber];
            }
            else
            {
                $bodyContents = $pageArray[$pageNumber];
            }
        }

        $returnArray[] =& $intro;
        $returnArray[] =& $bodyContents;

        return $returnArray;
    }

    /*!
      Renders rollover tags.
    */
    function &renderRollOver( $paragraph )
    {
        $pageContent = "";
        if ( $paragraph->name == "rollover" )
        {
            if  ( count( $paragraph->attributes ) > 0 )
            {
                foreach ( $paragraph->attributes as $attr )
                {
                    switch ( $attr->name )
                    {
                        case "url" :
                        {
                            $url = $attr->children[0]->content;
                        }
                        break;
                        
                        case "imageone" :
                        {
                            $imageOneID = $attr->children[0]->content;
                        }
                        break;
                        
                        case "imagetwo" :
                        {
                            $imageTwoID = $attr->children[0]->content;
                        }
                        break;
                        
                        case "description" :
                        {
                            $description = $attr->children[0]->content;
                        }
                        break;
                    }
                }
            }

            // get the imagevariations from the images.
            if ( is_numeric( $imageOneID ) )
            {
                $image = new eZImage( $imageOneID );
                $imageOneWidth = $image->width();
                $imageOneHeight = $image->height();
                $variation =& $image->requestImageVariation( $imageOneWidth, $imageOneHeight );
                $imageOneURL = "/" . $variation->imagePath();
            }

            if ( is_numeric( $imageTwoID ) )
            {
                $image = new eZImage( $imageTwoID );
                $imageTwoWidth = $image->width();
                $imageTwoHeight = $image->height();
                $variation =& $image->requestImageVariation( $imageTwoWidth, $imageOneWidth );
                $imageTwoURL = "/" . $variation->imagePath();
            }

            $this->Template->set_var( "url", $url );
            $this->Template->set_var( "image_one_url", $imageOneURL );
            $this->Template->set_var( "image_one_width", $imageOneWidth );
            $this->Template->set_var( "image_one_height", $imageOneHeight );
            
            $this->Template->set_var( "image_two_url", $imageTwoURL );
            $this->Template->set_var( "image_two_width", $imageTwoWidth );
            $this->Template->set_var( "image_two_height", $imageTwoHeight );

            $this->Template->set_var( "link_text", $description );

            $this->Template->set_var( "rollover_id", ++$this->RollOverCount );
            
            $pageContent = $this->Template->parse( "rollover", "rollover_tpl" );
        }

        return $pageContent;
    }

    
    /*!
      Renders header tags.
    */
    function &renderHeader( $paragraph )
    {
        $pageContent = "";
        if ( $paragraph->name == "header" )
        {
            $level = 1;
            if  ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "level" :
                    {
                       $level = $attr->children[0]->content;
                    }
                    break;
                }
            }

            if ( count( $paragraph->children ) > 0 )
                foreach ( $paragraph->children as $child )
                {
                    if ( $child->name == "text" )
                    {
                        $content = $child->content;
                    }
                    else
                    {
                        // nested tags in header ? not yet..
//                        $content .= $this->renderStandards( $child );
//                        $content .= $this->renderCustom( $child );
//                        $content .= $this->renderLink( $child );
                    }
            }

            $level = min( 6, $level );
            $level = max( 1, $level );


            $this->Template->set_var( "contents", $content );
            $pageContent =& $this->Template->parse( "header_" . $level, "header_" . $level. "_tpl" );
        }
        return $pageContent;
    }

    /*!
      Renders image tags.
    */
    function &renderImage( $paragraph )
    {
        $pageContent = "";
        if ( $paragraph->name == "image" )
        {
            $articleImages = $this->Article->images();
            $articleID = $this->Article->id();


            $level = 1;
            if  ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "id" :
                    {
                       $imageID = $attr->children[0]->content;
                    }
                    break;

                    case "align" :
                    {
                       $imageAlignment = $attr->children[0]->content;
                    }
                    break;

                    case "size" :
                    {
                       $imageSize = $attr->children[0]->content;
                    }
                    break;

                    case "href" :
                    {
                        $imageHref = $attr->children[0]->content;

                    }
                    break;

                    case "caption" :
                    {
                       $imageCaptionOverride = trim( $attr->children[0]->content );
                    }
                    break;

                    case "target" :
                    {
                       $imageTarget = trim( $attr->children[0]->content );
                    }
                    break;
                }
            }

            setType( $imageID, "integer" );

            foreach ( $articleImages as $imageArray )
            {
                if ( $imageArray["Placement"] == $imageID )
                    $image = $imageArray["Image"];
            }


            // check if it should link to original image
            if ( $imageHref == "originalimage" )
            {
                $imageHref = $image->filePath();
            }

            $hasMap = false;
            $mapString = "";
            if ( is_object( $image ) && ( $image->hasMap() == true ) )
            {
                print( "object image<br>" );
                $hasMap = true;
                include_once( "ezarticle/classes/ezimagemap.php" );
                $map = new eZImageMap( $image->id() );

                $elements =& $map->elements();

                // generate HTML map:
                $mapName = "eZMap_" . $image->id();
                $mapString = "<map name=\"$mapName\">\n";

                foreach ( $elements as $element )
                {
                    $elementParts = explode( "|", $element );

                    $imageMapHref = $elementParts[0];
                    if ( !preg_match( "%^(([a-z]+://)|/|#)%", $imageMapHref  ) )
                            $imageMapHref = "http://" . $imageMapHref;

                    if ( $elementParts[2] == "1" )
                    {
                        $mapString .= "<area shape=\"circle\" coords=\"" .
                         $elementParts[3] . "," .
                         $elementParts[4] . "," .
                         $elementParts[5] . "," . 
                         $elementParts[6] . "\" href=\"" . $imageMapHref . "\" />\n";
                    }
                    else
                    {
                        $mapString .= "<area shape=\"rect\" coords=\"" .
                             $elementParts[3] . "," .
                             $elementParts[4] . "," .
                             $elementParts[5] . "," . 
                             $elementParts[6] . "\" href=\"" . $imageMapHref . "\" />\n";
                    }
                }
                $mapString .= "</map>\n";
            }

            // add image if a valid image was found, else report an error in the log.
            if ( get_class( $image ) == "ezimage" )
            {
                $ini =& INIFile::globalINI();

                // store the relative ID to the image
                $this->UsedImageList[] = $imageID;

                if ( $hasMap == false )
                {
                    switch ( $imageSize )
                    {
                        case "small" :
                        {
                            $variation =& $image->requestImageVariation( $ini->read_var( "eZArticleMain", "SmallImageWidth" ),
                            $ini->read_var( "eZArticleMain", "SmallImageHeight" ) );
                        }
                        break;
                        case "medium" :
                        {
                            $variation =& $image->requestImageVariation( $ini->read_var( "eZArticleMain", "MediumImageWidth" ),
                            $ini->read_var( "eZArticleMain", "MediumImageHeight" ) );
                        }
                        break;
                        case "large" :
                        {
                            $variation =& $image->requestImageVariation( $ini->read_var( "eZArticleMain", "LargeImageWidth" ),
                            $ini->read_var( "eZArticleMain", "LargeImageHeight" ) );
                        }
                        break;

                        case "original" :
                        {
                            $variation =& $image;
                        }
                        break;

                        default :
                        {
                            $variation =& $image->requestImageVariation( $ini->read_var( "eZArticleMain", "MediumImageWidth" ),
                            $ini->read_var( "eZArticleMain", "MediumImageHeight" ) );
                        }
                    }
                }
                else
                {
                    // use original image if it's an image map.
                    $variation =& $image;
                }

                if ( get_class( $variation ) == "ezimage" )
                {
                    $imageURL = $variation->filePath();
                }
                else
                {
                    $imageURL = "/" . $variation->imagePath();
                }

                $imageWidth = $variation->width();
                $imageHeight = $variation->height();


                if ( $imageCaptionOverride != "" )
                {
                    if ( $imageCaptionOverride == "_blank" )
                    {
                        $imageCaption = "";
                    }
                    else
                    {
                        $imageCaption = $imageCaptionOverride;
                    }
                }
                else
                {
                    $imageCaption = $image->caption();
                }

                $imageID = $image->id();

                $viewMode = $GLOBALS["ViewMode"];

                if ( $viewMode == "" )
                {
                    $viewMode = "view";
                }


                $this->Template->set_var( "image_file_name", $image->fileName() );

                $this->Template->set_var( "image_width", $imageWidth );
                $this->Template->set_var( "image_height", $imageHeight );
                $this->Template->set_var( "image_alignment", $imageAlignment );
                $this->Template->set_var( "image_id", $imageID );
                $this->Template->set_var( "image_url", $imageURL );
                $this->Template->set_var( "article_id", $articleID );
                $this->Template->set_var( "view_mode", $viewMode );
                $this->Template->set_var( "caption", $imageCaption );
                $this->Template->set_var( "target", $imageTarget );

                $this->Template->set_var( "map_name", "usemap=\"#" . $mapName . "\"" );
                $this->Template->set_var( "map_string", $mapString );
                
                $this->Template->set_var( "referer_url", $GLOBALS["REQUEST_URI"] );

                if ( $hasMap == true )
                {
                    $imageHref = "0";
                }
                
                if ( $imageAlignment != "float"  )
                {
                    if ( $imageHref == "0" )
                    {
                        $this->Template->set_var( "ext_link", "" );
                        $this->Template->set_var( "image_link", "" );
                        $this->Template->parse( "no_link", "no_link_tpl" );
                    }
                    elseif ( $imageHref != "" )
                    {
                        // convert link
                        if ( !preg_match( "%^(([a-z]+://)|/|#)%", $imageHref ) )
                            $imageHref = "http://" . $imageHref;
                        $this->Template->set_var( "image_href", $imageHref );
                        $this->Template->set_var( "image_link", "" );
                        $this->Template->set_var( "no_link", "" );
                        $this->Template->parse( "ext_link", "ext_link_tpl" );
                    }
                    else
                    {
                        $this->Template->set_var( "ext_link", "" );
                        $this->Template->set_var( "no_link", "" );
                        $this->Template->parse( "image_link", "image_link_tpl" );
                    }

                    if ( trim( $imageCaption ) == "" )
                    {
                        $this->Template->set_var( "image_text", "" );
                    }
                    else
                    {
                        $this->Template->parse( "image_text", "image_text_tpl" );
                    }

                    $pageContent = $this->Template->parse( "image", "image_tpl" );
                }
                else
                {
                    if ( $imageHref == "0" )
                    {
                        $this->Template->set_var( "ext_link_float", "" );
                        $this->Template->set_var( "image_link_float", "" );
                        $this->Template->parse( "no_link_float", "no_link_float_tpl" );
                    }
                    elseif ( $imageHref != "" )
                    {
                        // convert link
                        if ( !preg_match( "%^(([a-z]+://)|/|#)%", $imageHref ) )
                            $imageHref = "http://" . $imageHref;
                        $this->Template->set_var( "image_href", $imageHref );
                        $this->Template->set_var( "image_link_float", "" );
                        $this->Template->set_var( "no_link_float", "" );
                        $this->Template->parse( "ext_link_float", "ext_link_float_tpl" );
                    }
                    else
                    {
                        $this->Template->set_var( "ext_link_float", "" );
                        $this->Template->set_var( "no_link_float", "" );
                        $this->Template->parse( "image_link_float", "image_link_float_tpl" );
                    }

                    $pageContent = $this->Template->parse( "image_float", "image_float_tpl" );
                }
            }
        }

        return $pageContent;
    }

    /*!
      Renders media tags.
    */
    function &renderMedia( $paragraph )
    {
        $pageContent = "";
        if ( $paragraph->name == "media" )
        {
            $articleMedia = $this->Article->media();
            $articleID = $this->Article->id();

            $level = 1;
            if  ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "id" :
                    {
                       $mediaID = $attr->children[0]->content;
                    }
                    break;
                }
            }

            setType( $mediaID, "integer" );

            $media = $articleMedia[$mediaID-1];

            // add media if a valid media was found, else report an error in the log.
            if ( get_class( $media ) == "ezmedia" )
            {
                $ini =& INIFile::globalINI();

                $mediaURL = $media->mediaPath();

                $mediaCaption = $media->caption();
                $mediaID = $media->id();

                $attributeString =& $media->attributeString();

                $this->Template->set_var( "media_id", $mediaID );
                $this->Template->set_var( "media_uri", $mediaURL );
                $this->Template->set_var( "article_id", $articleID );
                $this->Template->set_var( "caption", $mediaCaption );
                $this->Template->set_var( "attribute_string", $attributeString );

                $pageContent = $this->Template->parse( "media", "media_tpl" );

            }
        }
        return $pageContent;
    }

    /*!
      Renders file tags.
    */
    function &renderFile( $paragraph )
    {
	global $GlobalSiteIni;
        $pageContent = "";
        if ( $paragraph->name == "file" )
        {
            $articleFiles = $this->Article->files();
            $articleID = $this->Article->id();

            $level = 1;
            if  ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "id" :
                    {
                       $fileID = $attr->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                       $fileText = $attr->children[0]->content;
                    }
                    break;
                }
            }

            setType( $fileID, "integer" );

            $file = $articleFiles[$fileID-1];

            // add media if a valid media was found, else report an error in the log.
            if ( get_class( $file ) == "ezvirtualfile" )
            {
                $fileID = $file->id();

                $ini =& INIFile::globalINI();

                $fileName = str_replace( " ", "%20", $file->originalFileName() );
                $this->Template->set_var( "file_uri", $GlobalSiteIni->Index . "/filemanager/download/" . $fileID . "/" . $fileName );
                $this->Template->set_var( "text", $fileText );

                $pageContent = $this->Template->parse( "file", "file_tpl" );

            }
        }
        return $pageContent;
    }

    function &renderPlain( $paragraph )
    {
        // ordinary text
        if ( $paragraph->name == "#text" || $paragraph->name == "text" )
        {
            $paragraph_text = $paragraph->content;
            if ( $paragraph_text != "" and $paragraph_text[0] == "\n" )
            {
                if ( $this->PrevTag != "link" )
                    $paragraph_text[0] = " ";
            }
            $pageContent = eZTextTool::nl2br( $paragraph_text, $this->BrOverride );
        }
        return $pageContent;
    }

    /*!
      Renders the standard tags like bold, italic ...
    */
    function &renderStandards( $paragraph )
    {
        $pageContent = "";
        switch ( $paragraph->name )
        {
            case "bullet" :
            case "list" :
            {
                $tmpContent = "";
                $content = "";
                $lines = array();
                $oldBullet = true;
                foreach ( $paragraph->children as $child )
                {
                    if ( $child->name == "li" )
                    {
                        $oldBullet = false;
                        $content = "";
                        if ( count( $child->children ) > 0 )
                        foreach ( $child->children as $listItem )
                        {
                            if ( $listItem->name == "text" )
                            {
                                $content .= $listItem->content;
                            }
                            else
                            {
                                $content .= $this->renderStandards( $listItem );
                                $content .= $this->renderCustom( $listItem );
                                $content .= $this->renderLink( $listItem );
                                $content .= $this->renderImage( $listItem );
                                $content .= $this->renderMedia( $listItem );
                                $content .= $this->renderFile( $listItem );
                                $content .= $this->renderHeader( $listItem );
                                $content .= $this->renderHr( $listItem );
                                $content .= $this->renderTable( $listItem );
                                $content .= $this->renderRollOver( $listItem );
                            }

                        }
                        $lines[] = $content;
                    }
                    else
                    {
                        if ( $child->name == "text" )
                        {
                            $content .= $child->content;
                        }
                        else
                        {
                            $content .= $this->renderStandards( $child );
                            $content .= $this->renderCustom( $child );
                            $content .= $this->renderLink( $child );
                            $content .= $this->renderImage( $child );
                            $content .= $this->renderMedia( $child );
                            $content .= $this->renderFile( $child );
                            $content .= $this->renderHeader( $child );
                            $content .= $this->renderHr( $child );
                            $content .= $this->renderTable( $child );
                            $content .= $this->renderRollOver( $child );
                        }
                    }
                }

                // compatible with old style bullet lists where \n was the
                // itemseparator.
                if ( $oldBullet == true )
                {
                    $content = trim( $content );
                    $lines = explode( "\n", $content );
                }

                if ( $paragraph->name == "bullet" )
                {
                    $this->Template->set_var( "bullet", "" );
                    $this->Template->set_var( "bullet_item", "" );

                    foreach ( $lines as $line )
                    {
                        $this->Template->set_var( "contents", $line );
                        $tmpContent = $this->Template->parse( "bullet_item", "bullet_item_tpl", true );
                    }
                    $pageContent = $this->Template->parse( "bullet", "bullet_tpl" );
                }
                else
                {
                    $this->Template->set_var( "list", "" );
                    $this->Template->set_var( "list_item", "" );

                    foreach ( $lines as $line )
                    {
                        $this->Template->set_var( "contents", $line );
                        $tmpContent = $this->Template->parse( "list_item", "list_item_tpl", true );
                    }
                    $pageContent = $this->Template->parse( "list", "list_tpl" );
                }

            } break;

            case "bold" :
            case "italic" :
            case "underline" :
            case "strike" :
            case "strong" :
            case "factbox" :
            case "quote" :
            case "pre" :
            case "html" :
            case "form" :
            {
                $tmpContent = "";
                if ( count( $paragraph->children ) )
                foreach ( $paragraph->children as $child )
                {
                    if ( $child->name == "text" )
                    {
                        if ( $paragraph->name == "pre"  || $paragraph->name == "html")
                            $tmpContent .= $child->content;
                        else
                            $tmpContent .= eZTextTool::nl2br( $child->content, $this->BrOverride );

                    }
                    else
                    {
                        $tmpContent .= $this->renderStandards( $child );
                        $tmpContent .= $this->renderCustom( $child );
                        $tmpContent .= $this->renderLink( $child );
                        $tmpContent .= $this->renderImage( $child );
                        $tmpContent .= $this->renderMedia( $child );
                        $tmpContent .= $this->renderFile( $child );
                        $tmpContent .= $this->renderHeader( $child );
                        $tmpContent .= $this->renderHr( $child );
                        $tmpContent .= $this->renderTable( $child );
                        $tmpContent .= $this->renderRollOver( $child );
                    }
                }

                $this->Template->set_var( "contents", $tmpContent );

                switch ( $paragraph->name )
                {
                    case "bold" :
                        $pageContent = trim( $this->Template->parse( "bold", "bold_tpl" ) );
                        break;
                    case "italic" :
                        $pageContent = trim( $this->Template->parse( "italic", "italic_tpl" ) );
                        break;
                    case "underline" :
                        $pageContent = trim( $this->Template->parse( "underline", "underline_tpl" ) );
                    break;
                    case "strong" :
                        $pageContent = trim( $this->Template->parse( "strong", "strong_tpl" ) );
                    break;
                    case "strike" :
                        $pageContent = trim( $this->Template->parse( "strike", "strike_tpl" ) );
                    break;
                    case "factbox" :
                        $pageContent = trim( $this->Template->parse( "factbox", "factbox_tpl" ) );
                    break;
                    case "pre" :
                        $this->Template->set_var( "contents", htmlspecialchars( $tmpContent ) );
                        $pageContent = trim( $this->Template->parse( "pre", "pre_tpl" ) );
                    break;
                    case "html" :
                        $pageContent = trim( $this->Template->parse( "html", "html_tpl" ) );
                    break;
                    case "quote" :
                        $this->Template->set_var( "contents", trim( $tmpContent ) );
                        $pageContent = trim( $this->Template->parse( "quote", "quote_tpl" ) );
                    break;
                    case "form" :
                    {
                        include_once( "ezform/classes/ezformrenderer.php" );

                        $forms = $this->Article->forms();
                        if ( count ($forms) == 1 )
                        {
                            $formRenderer = new eZFormRenderer();
                            $output = $formRenderer->renderForm(  $forms[0] );

                            $pageContent = $output;
                        }
                    }
                    break;
                }

            }break;
        }

        return $pageContent;
    }


    /*!
      Renders custom tags.
    */
    function &renderCustom( $paragraph )
    {
        $pageContent = "";
        $tagName = $paragraph->name;

        if ( in_array( $tagName, $this->CustomTagsArray ) )
        {
            $tmpContent = "";
            if ( count( $paragraph->children ) )
            {
                foreach ( $paragraph->children as $child )
                {
                    if ( $child->name == "text" )
                    {
                        $tmpContent .= eZTextTool::nl2br( $child->content, $this->BrOverride );
                    }
                    else
                    {
                        $tmpContent .= $this->renderStandards( $child );
                        $tmpContent .= $this->renderCustom( $child );
                        $tmpContent .= $this->renderLink( $child );
                        $tmpContent .= $this->renderImage( $child );
                        $tmpContent .= $this->renderMedia( $media );
                        $tmpContent .= $this->renderFile( $media );
                        $tmpContent .= $this->renderHeader( $child );
                        $tmpContent .= $this->renderHr( $child );
                        $tmpContent .= $this->renderTable( $child );
                        $tmpContent .= $this->renderRollOver( $child );
                    }
                }
            }

            $this->Template->set_var( "contents", $tmpContent );

            $pageContent = trim( $this->Template->parse( "$tagName", $tagName ."_tpl" ) );
        }

        return $pageContent;
    }

    /*!
      Renders link tags.
    */
    function &renderLink( $paragraph )
    {
        $pageContent = "";
        if ( $paragraph->name == "link" )
        {
            if ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "href" :
                    {
                       $href = $attr->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                       $text = $attr->children[0]->content;
                    }
                    break;

                    case "target" :
                    {
                       $target = $attr->children[0]->content;
                    }
                    break;
                }
            }

            if ( !preg_match( "%^(([a-z]+://)|/|#)%", $href ) )
                $href = "http://" . $href;

            $this->Template->set_var( "href", $href );
			if ( !isset( $target ) )
				$target = "";
            $this->Template->set_var( "target", $target );
            $this->Template->set_var( "link_text", $text );

            $pageContent =& trim( $this->Template->parse( "link", "link_tpl" ) );
        }

        if ( $paragraph->name == "popuplink" )
        {
            if ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "href" :
                    {
                       $href = $attr->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                       $text = $attr->children[0]->content;
                    }
                    break;
                }
            }

            if ( !preg_match( "%^(([a-z]+://)|/|#)%", $href ) )
                $href = "http://" . $href;

            $this->Template->set_var( "href", $href );
            $this->Template->set_var( "link_text", $text );
            $pageContent =& trim( $this->Template->parse( "popuplink", "popuplink_tpl" ) );
        }


        // ez anchor
        if ( $paragraph->name == "ezanchor" )
        {
            foreach ( $paragraph->attributes as $anchorItem )
                {
                    switch ( $anchorItem->name )
                    {
                        case "href" :
                        {
                            $href = $anchorItem->children[0]->content;
                        }
                        break;
                    }
                }

            $pageContent .= "<a name=\"$href\"></a>";
        }


        // mail
        if ( $paragraph->name == "mail" )
        {
            if ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $mailItem )
            {
                switch ( $mailItem->name )
                {
                    case "to" :
                    {
                        $to = $mailItem->children[0]->content;
                    }
                    break;

                    case "subject" :
                    {
                        $subject = $mailItem->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                        $text = $mailItem->children[0]->content;
                    }
                    break;
                }
            }

            $this->Template->set_var( "href", "mailto:$to?subject=$subject" );
            $this->Template->set_var( "link_text", $text );
            $pageContent =& $this->Template->parse( "link", "link_tpl" );
            $pageContent = preg_replace("/\s+target=\"{target}\"\s*/", "", $pageContent );
        }

        // ezarticle
        if ( $paragraph->name == "ezarticle" )
        {
            if ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "id" :
                    {
                       $id = $attr->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                       $text = $attr->children[0]->content;
                       $text = htmlentities( $text );
                    }
                    break;
                }
            }

            global $GlobalSiteIni;
            $href = "$GlobalSiteIni->WWWDir$GlobalSiteIni->Index/article/view/" . $id;
            $this->Template->set_var( "href", $href );
            $this->Template->set_var( "target", "" );
            $this->Template->set_var( "link_text", $text );
            $pageContent =& trim( $this->Template->parse( "link", "link_tpl" ) );
        }

        // ezstatic
        if ( $paragraph->name == "ezstatic" )
        {
            if ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "id" :
                    {
                       $id = $attr->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                       $text = $attr->children[0]->content;
                       $text = htmlentities( $text );
                    }
                    break;
                }
            }

            global $GlobalSiteIni;
            $href = "$GlobalSiteIni->WWWDir$GlobalSiteIni->Index/article/static/" . $id;
            $this->Template->set_var( "href", $href );
            $this->Template->set_var( "target", "" );
            $this->Template->set_var( "link_text", $text );
            $pageContent =& trim( $this->Template->parse( "link", "link_tpl" ) );
        }

        // ezcategory
        if ( $paragraph->name == "ezcategory" )
        {
            if ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "id" :
                    {
                       $id = $attr->children[0]->content;
                    }
                    break;

                    case "text" :
                    {
                       $text = $attr->children[0]->content;
                       $text = htmlentities( $text );
                    }
                    break;
                }
            }

            global $GlobalSiteIni;
            $href = "$GlobalSiteIni->WWWDir$GlobalSiteIni->Index/article/archive/" . $id;
            $this->Template->set_var( "href", $href );
            $this->Template->set_var( "target", "" );
            $this->Template->set_var( "link_text", $text );
            $pageContent =& trim( $this->Template->parse( "link", "link_tpl" ) );
        }
        return $pageContent;
    }

    /*!
      Returns the relative ID to the images used ( rendered ) in this article
    */
    function usedImageList()
    {
        return $this->UsedImageList;
    }


    function &renderHr( $paragraph )
    {
        $pageContent = "";
        if ( $paragraph->name == "hr" )
        {
            $pageContent =& $this->Template->parse( "hr", "hr_tpl" );
        }
        return $pageContent;
    }

    /*!
      Renders a table object.
    */
    function &renderTable( $paragraph )
    {
        $template = $this->Template;
        if ( $paragraph->name == "table" )
        {
            $template->set_var( "tr", "" );
            $template->set_var( "td", "" );

            $tableWidth = "100%";
            $tableBorder = 1;
            if  ( count( $paragraph->attributes ) > 0 )
            foreach ( $paragraph->attributes as $attr )
            {
                switch ( $attr->name )
                {
                    case "width" :
                    {
                        $tableWidth = $attr->children[0]->content;
                    }
                    break;
                    case "border" :
                    {
                        $tableBorder = $attr->children[0]->content;
                    }
                    break;
                }
            }

            foreach ( $paragraph->children as $row )
            {
                if ( $row->name == "tr" )
                {
                    $template->set_var( "td", "" );

                    foreach ( $row->children as $data )
                    {
                        if ( $data->name == "td" )
                        {
                            $tdWidth = "";
                            $tdColspan = 1;
                            $tdRowspan = 1;
                            if  ( isset( $data->attributes ) and count( $data->attributes ) > 0 )
                                foreach ( $data->attributes as $attr )
                                {
                                    switch ( $attr->name )
                                    {
                                        case "width" :
                                        {
                                            $tdWidth = $attr->children[0]->content;
                                        }
                                        break;
                                        case "colspan" :
                                        {
                                            $tdColspan = $attr->children[0]->content;
                                        }
                                        break;
                                        case "rowspan" :
                                        {
                                            $tdRowspan = $attr->children[0]->content;
                                        }
                                        break;
                                    }
                                }

                            $childrenData =& $this->renderChildren( $data );
                            $template->set_var( "contents", $childrenData );
                            $template->set_var( "td_width", $tdWidth );
                            $template->set_var( "td_colspan", $tdColspan );
                            $template->set_var( "td_rowspan", $tdRowspan );
                            $template->parse( "td", "td_tpl", true );
                        }
                    }
                    $template->parse( "tr", "tr_tpl", true );
                }
            }
            $template->set_var( "table_width", $tableWidth );
            $template->set_var( "table_border", $tableBorder );
            $pageContent =& $template->parse( "table", "table_tpl" );
        }

        return $pageContent;
    }

    /*!
      \private
      Renders the children for this paragraph and returns the contents.
     */
    function &renderChildren( $paragraph )
    {
		$tmpContent = "";
        // render children
        if ( count( $paragraph->children ) )
            foreach ( $paragraph->children as $child )
            {
                if ( $child->name == "text" )
                {
					if ( !isset( $child->content ) )
						$child->content = "";
                    $tmpContent .= eZTextTool::nl2br( $child->content, $this->BrOverride );
                }
                else
                {
                    $tmpContent .= $this->renderStandards( $child );
                    $tmpContent .= $this->renderCustom( $child );
                    $tmpContent .= $this->renderLink( $child );
                    $tmpContent .= $this->renderImage( $child );
                    $tmpContent .= $this->renderMedia( $child );
                    $tmpContent .= $this->renderFile( $child );
                    $tmpContent .= $this->renderHeader( $child );
                    $tmpContent .= $this->renderHr( $child );
                    $tmpContent .= $this->renderTable( $child );
                    $tmpContent .= $this->renderRollOver( $child );
                }
            }
        return $tmpContent;
    }

    var $UsedImageList;
    var $Article;
    var $PrevTag;
    var $Template;

    /// stores the <br/> override variable.
    var $BrOverride = true;

    /// stores the custom tags array
    var $CustomTagsArray;

    // a counter for rollover.
    var $RollOverCount;
}

?>
